/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.assignment.hard;

import org.openimaj.knn.FloatNearestNeighbours;
import org.openimaj.knn.FloatNearestNeighboursProvider;
import org.openimaj.knn.approximate.FloatNearestNeighboursKDTree;
import org.openimaj.ml.clustering.CentroidsProvider;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.util.pair.IntFloatPair;

public class KDTreeFloatEuclideanAssigner
implements HardAssigner<float[], float[], IntFloatPair> {
    protected FloatNearestNeighboursKDTree nn;

    public KDTreeFloatEuclideanAssigner(CentroidsProvider<float[]> provider) {
        FloatNearestNeighbours internal;
        if (provider instanceof FloatNearestNeighboursProvider && (internal = ((FloatNearestNeighboursProvider)provider).getNearestNeighbours()) != null && internal instanceof FloatNearestNeighboursKDTree) {
            this.nn = (FloatNearestNeighboursKDTree)internal;
            return;
        }
        this.nn = new FloatNearestNeighboursKDTree((float[][])provider.getCentroids(), 8, 768);
    }

    public KDTreeFloatEuclideanAssigner(float[][] data) {
        this.nn = new FloatNearestNeighboursKDTree(data, 8, 768);
    }

    public int[] assign(float[][] data) {
        int[] argmins = new int[data.length];
        float[] mins = new float[data.length];
        this.nn.searchNN(data, argmins, mins);
        return argmins;
    }

    @Override
    public int assign(float[] data) {
        return this.assign(new float[][]{data})[0];
    }

    public void assignDistance(float[][] data, int[] indices, float[] distances) {
        this.nn.searchNN(data, indices, distances);
    }

    @Override
    public IntFloatPair assignDistance(float[] data) {
        int[] index = new int[1];
        float[] distance = new float[1];
        this.nn.searchNN((float[][])new float[][]{data}, index, distance);
        return new IntFloatPair(index[0], distance[0]);
    }

    @Override
    public int size() {
        return this.nn.size();
    }

    @Override
    public int numDimensions() {
        return this.nn.numDimensions();
    }
}

