/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.dbscan;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.data.DataSource;
import org.openimaj.knn.DoubleNearestNeighbours;
import org.openimaj.knn.DoubleNearestNeighboursExact;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.ml.clustering.DataClusterer;
import org.openimaj.ml.clustering.SpatialClusterer;
import org.openimaj.ml.clustering.dbscan.DBSCAN;
import org.openimaj.ml.clustering.dbscan.DoubleDBSCANClusters;
import org.openimaj.ml.clustering.dbscan.neighbourhood.RegionMode;
import org.openimaj.util.pair.IntDoublePair;

public class DoubleNNDBSCAN
extends DBSCAN
implements SpatialClusterer<DoubleDBSCANClusters, double[]>,
DataClusterer<double[][], DoubleDBSCANClusters> {
    private NearestNeighboursFactory<? extends DoubleNearestNeighbours, double[]> nnf;
    private double eps;
    private int minPts;

    public DoubleNNDBSCAN(double eps, int minPts, NearestNeighboursFactory<? extends DoubleNearestNeighbours, double[]> nnf) {
        this.eps = eps;
        this.nnf = nnf;
        this.minPts = minPts;
    }

    public DoubleNNDBSCAN(double eps, int minPts) {
        this(eps, minPts, (NearestNeighboursFactory<? extends DoubleNearestNeighbours, double[]>)new DoubleNearestNeighboursExact.Factory());
    }

    @Override
    public DoubleDBSCANClusters cluster(double[][] data) {
        DBSCAN.State state = new DBSCAN.State(data.length, new NNRegionMode(data), this.noiseAsClusters);
        return this.dbscan(state);
    }

    @Override
    public DoubleDBSCANClusters cluster(DataSource<double[]> data) {
        double[][] allData = new double[data.size()][];
        Iterator iterator = data.iterator();
        for (int i = 0; i < allData.length; ++i) {
            allData[i] = (double[])iterator.next();
        }
        return this.cluster(allData);
    }

    public int[][] performClustering(double[][] data) {
        return this.cluster(data).clusters();
    }

    public double getEps() {
        return this.eps;
    }

    public String toString() {
        return String.format("%s: eps=%2.2f, minpts=%d, NN=%s", this.getClass().getSimpleName(), this.eps, this.minPts, this.nnf.getClass().getSimpleName());
    }

    class NNRegionMode
    implements RegionMode<IntDoublePair> {
        double[][] data;
        DoubleNearestNeighbours nn;

        public NNRegionMode(double[][] data) {
            this.data = data;
            this.nn = (DoubleNearestNeighbours)DoubleNNDBSCAN.this.nnf.create((Object[])data);
        }

        @Override
        public List<IntDoublePair> regionQuery(int index) {
            List res = this.nn.searchKNN((Object)this.data[index], this.data.length);
            ArrayList<IntDoublePair> ret = new ArrayList<IntDoublePair>();
            for (IntDoublePair intFloatPair : res) {
                if (!(intFloatPair.second < DoubleNNDBSCAN.this.eps)) break;
                ret.add(intFloatPair);
            }
            return ret;
        }

        @Override
        public boolean validRegion(List<IntDoublePair> region) {
            return region.size() >= DoubleNNDBSCAN.this.minPts;
        }
    }
}

