/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.clustering.dbscan;

import ch.akuhn.matrix.SparseMatrix;
import ch.akuhn.matrix.Vector;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.ml.clustering.SparseMatrixClusterer;
import org.openimaj.ml.clustering.dbscan.DBSCAN;
import org.openimaj.ml.clustering.dbscan.DoubleDBSCANClusters;
import org.openimaj.ml.clustering.dbscan.neighbourhood.RegionMode;
import org.openimaj.util.pair.IntDoublePair;

public abstract class SparseMatrixDBSCAN
extends DBSCAN
implements SparseMatrixClusterer<DoubleDBSCANClusters> {
    private double eps;
    private int minPts;

    public SparseMatrixDBSCAN(double eps, int minPts) {
        this.eps = eps;
        this.minPts = minPts;
    }

    public int[][] performClustering(SparseMatrix data) {
        return ((DoubleDBSCANClusters)this.cluster(data)).clusters();
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public String toString() {
        return String.format("%s: eps=%2.2f, minpts=%d", this.getClass().getSimpleName(), this.eps, this.minPts);
    }

    class SparseMatrixRegionMode
    implements RegionMode<IntDoublePair> {
        private SparseMatrix mat;
        private boolean distanceMode;

        public SparseMatrixRegionMode(SparseMatrix mat, boolean distanceMode) {
            this.mat = mat;
            this.distanceMode = distanceMode;
        }

        @Override
        public List<IntDoublePair> regionQuery(int index) {
            Vector vec = this.mat.row(index);
            ArrayList<IntDoublePair> ret = new ArrayList<IntDoublePair>();
            if (this.distanceMode) {
                ret.add(IntDoublePair.pair((int)index, (double)0.0));
                for (Vector.Entry ent : vec.entries()) {
                    double v = ent.value;
                    if (v < SparseMatrixDBSCAN.this.eps) {
                        ret.add(IntDoublePair.pair((int)ent.index, (double)v));
                        continue;
                    }
                    break;
                }
            } else {
                ret.add(IntDoublePair.pair((int)index, (double)(SparseMatrixDBSCAN.this.eps * 2.0)));
                for (Vector.Entry ent : vec.entries()) {
                    if (!(ent.value > SparseMatrixDBSCAN.this.eps)) continue;
                    ret.add(IntDoublePair.pair((int)ent.index, (double)ent.value));
                }
            }
            return ret;
        }

        @Override
        public boolean validRegion(List<IntDoublePair> region) {
            return region.size() >= SparseMatrixDBSCAN.this.minPts;
        }
    }
}

