/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.alignment;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.detection.keypoints.FKEFaceDetector;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypoint;
import org.openimaj.image.processing.face.detection.keypoints.KEDetectedFace;

public class AffineAligner
implements FaceAligner<KEDetectedFace> {
    protected static final float[][] Pmu = new float[][]{{25.0347f, 34.1802f, 44.1943f, 53.4623f, 34.1208f, 39.3564f, 44.9156f, 31.1454f, 47.8747f}, {34.158f, 34.1659f, 34.0936f, 33.8063f, 45.4179f, 47.0043f, 45.3628f, 53.0275f, 52.7999f}};
    static final int CANONICAL_SIZE = 80;
    int facePatchWidth = 80;
    int facePatchHeight = 80;
    float facePatchBorderPercentage = 0.225f;
    private FImage mask;

    public AffineAligner() {
        this(AffineAligner.loadDefaultMask());
    }

    public AffineAligner(FImage mask) {
        this.mask = mask;
    }

    public AffineAligner(FImage mask, float facePatchBorderPercentage) {
        this.mask = mask;
        this.facePatchBorderPercentage = facePatchBorderPercentage;
        this.facePatchHeight = mask.height;
        this.facePatchWidth = mask.width;
    }

    public AffineAligner(int facePatchWidth, int facePatchHeight, float facePatchBorderPercentage) {
        this.mask = new FImage(facePatchWidth, facePatchHeight);
        this.mask.fill(1.0f);
        this.facePatchBorderPercentage = facePatchBorderPercentage;
        this.facePatchWidth = facePatchWidth;
        this.facePatchHeight = facePatchHeight;
    }

    @Override
    public FImage align(KEDetectedFace descriptor) {
        int facePatchSize = Math.max(this.facePatchWidth, this.facePatchHeight);
        double size = (double)facePatchSize + 2.0 * (double)facePatchSize * (double)this.facePatchBorderPercentage;
        double sc = 80.0 / size;
        Matrix T = AffineAligner.estimateAffineTransform(descriptor);
        T.set(0, 0, T.get(0, 0) * sc);
        T.set(1, 1, T.get(1, 1) * sc);
        T.set(0, 1, T.get(0, 1) * sc);
        T.set(1, 0, T.get(1, 0) * sc);
        FImage J = FKEFaceDetector.pyramidResize(descriptor.getFacePatch(), T);
        FImage bigPatch = FKEFaceDetector.extractPatch(J, T, (int)size, (int)((float)facePatchSize * this.facePatchBorderPercentage));
        return ((FImage)bigPatch.extractCenter(this.facePatchWidth, this.facePatchHeight)).extractROI(0, 0, this.facePatchWidth, this.facePatchHeight).multiplyInplace(this.mask);
    }

    public static Matrix estimateAffineTransform(KEDetectedFace face) {
        return AffineAligner.estimateAffineTransform(face.getKeypoints());
    }

    protected static Matrix estimateAffineTransform(FacialKeypoint[] pts) {
        float emin = Float.POSITIVE_INFINITY;
        Matrix T = null;
        for (int c = 0; c < 9; ++c) {
            Matrix A = new Matrix(8, 3);
            Matrix B = new Matrix(8, 3);
            int j = 0;
            for (int i = 0; i < 9; ++i) {
                if (i == 8 - c) continue;
                A.set(j, 0, (double)Pmu[0][i]);
                A.set(j, 1, (double)Pmu[1][i]);
                A.set(j, 2, 1.0);
                B.set(j, 0, (double)pts[i].position.x);
                B.set(j, 1, (double)pts[i].position.y);
                B.set(j, 2, 1.0);
                ++j;
            }
            Matrix Tc = A.solve(B).transpose();
            Matrix P1 = Tc.times(A.transpose());
            Matrix D = P1.minus(B.transpose());
            float e = 0.0f;
            for (int cc = 0; cc < D.getColumnDimension(); ++cc) {
                float colsum = 0.0f;
                for (int rr = 0; rr < D.getRowDimension(); ++rr) {
                    colsum = (float)((double)colsum + D.get(rr, cc) * D.get(rr, cc));
                }
                e = (float)((double)e + Math.sqrt(colsum));
            }
            if (!(e < emin)) continue;
            emin = e;
            T = Tc;
        }
        return T;
    }

    private static FImage loadDefaultMask() {
        try {
            return ImageUtilities.readF((InputStream)FaceAligner.class.getResourceAsStream("affineMask.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public FImage getMask() {
        return this.mask;
    }

    public void readBinary(DataInput in) throws IOException {
        this.facePatchWidth = in.readInt();
        this.facePatchHeight = in.readInt();
        this.facePatchBorderPercentage = in.readFloat();
        this.mask = ImageUtilities.readF((DataInput)in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.facePatchWidth);
        out.writeInt(this.facePatchHeight);
        out.writeFloat(this.facePatchBorderPercentage);
        ImageUtilities.write((Image)this.mask, (String)"png", (DataOutput)out);
    }
}

