/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.model.FisherImages;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;
import org.openimaj.io.IOUtils;
import org.openimaj.ml.training.BatchTrainer;
import org.openimaj.util.pair.IndependentPair;

@Reference(type=ReferenceType.Article, author={"Belhumeur, Peter N.", "Hespanha, Jo\\~{a}o P.", "Kriegman, David J."}, title="Fisherfaces vs. Fisherfaces: Recognition Using Class Specific Linear Projection", year="1997", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"711", "", "720"}, url="http://dx.doi.org/10.1109/34.598228", month="July", number="7", publisher="IEEE Computer Society", volume="19", customData={"issn", "0162-8828", "numpages", "10", "doi", "10.1109/34.598228", "acmid", "261512", "address", "Washington, DC, USA", "keywords", "Appearance-based vision, face recognition, illumination invariance, Fisher's linear discriminant."})
public class FisherFaceFeature
implements FacialFeature,
FeatureVectorProvider<DoubleFV> {
    private DoubleFV fv;

    protected FisherFaceFeature() {
        this(null);
    }

    public FisherFaceFeature(DoubleFV fv) {
        this.fv = fv;
    }

    public void readBinary(DataInput in) throws IOException {
        this.fv = new DoubleFV();
        this.fv.readBinary(in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.fv.writeBinary(out);
    }

    public DoubleFV getFeatureVector() {
        return this.fv;
    }

    public static class Extractor<T extends DetectedFace>
    implements FacialFeatureExtractor<FisherFaceFeature, T>,
    BatchTrainer<IndependentPair<?, T>> {
        FisherImages fisher = null;
        FaceAligner<T> aligner = null;

        public Extractor(int numComponents, FaceAligner<T> aligner) {
            this(new FisherImages(numComponents), aligner);
        }

        public Extractor(FisherImages basis, FaceAligner<T> aligner) {
            this.fisher = basis;
            this.aligner = aligner;
        }

        public FisherFaceFeature extractFeature(T face) {
            FImage patch = this.aligner.align(face);
            DoubleFV fv = this.fisher.extractFeature(patch);
            return new FisherFaceFeature(fv);
        }

        public void readBinary(DataInput in) throws IOException {
            this.fisher.readBinary(in);
            String alignerClass = in.readUTF();
            this.aligner = (FaceAligner)IOUtils.newInstance((String)alignerClass);
            this.aligner.readBinary(in);
        }

        public byte[] binaryHeader() {
            return this.getClass().getName().getBytes();
        }

        public void writeBinary(DataOutput out) throws IOException {
            this.fisher.writeBinary(out);
            out.writeUTF(this.aligner.getClass().getName());
            this.aligner.writeBinary(out);
        }

        public void train(final List<? extends IndependentPair<?, T>> data) {
            AbstractList patches = new AbstractList<IndependentPair<?, FImage>>(){

                @Override
                public IndependentPair<?, FImage> get(int index) {
                    return IndependentPair.pair((Object)((IndependentPair)data.get(index)).firstObject(), (Object)Extractor.this.aligner.align((DetectedFace)((IndependentPair)data.get(index)).secondObject()));
                }

                @Override
                public int size() {
                    return data.size();
                }
            };
            this.fisher.train((List)patches);
        }

        public void train(Map<?, ? extends List<T>> data) {
            ArrayList<IndependentPair> list = new ArrayList<IndependentPair>();
            for (Map.Entry<?, List<T>> e : data.entrySet()) {
                for (DetectedFace i : e.getValue()) {
                    list.add(IndependentPair.pair(e.getKey(), (Object)this.aligner.align(i)));
                }
            }
            this.fisher.train(list);
        }

        public <KEY> void train(GroupedDataset<KEY, ? extends ListDataset<T>, T> data) {
            ArrayList<IndependentPair> list = new ArrayList<IndependentPair>();
            for (Object e : data.getGroups()) {
                for (DetectedFace i : (ListDataset)data.getInstances(e)) {
                    if (i == null) continue;
                    list.add(IndependentPair.pair(e, (Object)this.aligner.align(i)));
                }
            }
            this.fisher.train(list);
        }
    }
}

