/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.feature.FloatFV;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.dense.binarypattern.ExtendedLocalBinaryPattern;
import org.openimaj.image.feature.dense.binarypattern.UniformBinaryPattern;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.alignment.IdentityAligner;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;
import org.openimaj.io.IOUtils;

public class LocalLBPHistogram
implements FacialFeature,
FeatureVectorProvider<FloatFV> {
    float[][][] histograms;
    transient FloatFV featureVector;

    protected void initialise(FImage face, FImage mask, int blocksX, int blocksY, int samples, int radius) {
        int[][] pattern = ExtendedLocalBinaryPattern.calculateLBP((FImage)face, (float)radius, (int)samples);
        boolean[][][] maps = UniformBinaryPattern.extractPatternMaps((int[][])pattern, (int)samples);
        int bx = face.width / blocksX;
        int by = face.height / blocksY;
        this.histograms = new float[blocksY][blocksX][maps.length];
        for (int p = 0; p < maps.length; ++p) {
            for (int y = 0; y < blocksY; ++y) {
                for (int x = 0; x < blocksX; ++x) {
                    for (int j = 0; j < by; ++j) {
                        for (int i = 0; i < bx; ++i) {
                            if (!maps[p][y * by + j][x * bx + i]) continue;
                            float[] fArray = this.histograms[y][x];
                            int n = p;
                            fArray[n] = fArray[n] + 1.0f;
                        }
                    }
                }
            }
        }
        for (int y = 0; y < blocksY; ++y) {
            for (int x = 0; x < blocksX; ++x) {
                int p;
                float count = 0.0f;
                for (p = 0; p < maps.length; ++p) {
                    count += this.histograms[y][x][p];
                }
                p = 0;
                while (p < maps.length) {
                    float[] fArray = this.histograms[y][x];
                    int n = p++;
                    fArray[n] = fArray[n] / count;
                }
            }
        }
        this.updateFeatureVector();
    }

    protected void updateFeatureVector() {
        this.featureVector = new FloatFV(this.histograms.length * this.histograms[0].length * this.histograms[0][0].length);
        int i = 0;
        for (int y = 0; y < this.histograms.length; ++y) {
            for (int x = 0; x < this.histograms[0].length; ++x) {
                for (int p = 0; p < this.histograms[0][0].length; ++p) {
                    ((float[])this.featureVector.values)[i] = this.histograms[y][x][p];
                    ++i;
                }
            }
        }
    }

    public byte[] binaryHeader() {
        return "LBPH".getBytes();
    }

    public void readBinary(DataInput in) throws IOException {
        int by = in.readInt();
        int bx = in.readInt();
        int p = in.readInt();
        this.histograms = new float[by][bx][p];
        for (int j = 0; j < by; ++j) {
            for (int i = 0; i < bx; ++i) {
                for (int k = 0; k < p; ++k) {
                    this.histograms[j][i][k] = in.readFloat();
                }
            }
        }
        this.updateFeatureVector();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.histograms.length);
        out.writeInt(this.histograms[0].length);
        out.writeInt(this.histograms[0][0].length);
        float[][][] fArray = this.histograms;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[][] hist1;
            float[][] fArray2 = hist1 = fArray[i];
            int n2 = fArray2.length;
            for (int j = 0; j < n2; ++j) {
                float[] hist2;
                for (float h : hist2 = fArray2[j]) {
                    out.writeFloat(h);
                }
            }
        }
    }

    public FloatFV getFeatureVector() {
        if (this.featureVector == null) {
            this.updateFeatureVector();
        }
        return this.featureVector;
    }

    public static class Extractor<T extends DetectedFace>
    implements FacialFeatureExtractor<LocalLBPHistogram, T> {
        FaceAligner<T> aligner;
        int blocksX = 25;
        int blocksY = 25;
        int samples = 8;
        int radius = 1;

        public Extractor() {
            this.aligner = new IdentityAligner();
        }

        public Extractor(FaceAligner<T> aligner) {
            this.aligner = aligner;
        }

        public Extractor(FaceAligner<T> aligner, int blocksX, int blocksY, int samples, int radius) {
            this.aligner = aligner;
            this.blocksX = blocksX;
            this.blocksY = blocksY;
            this.samples = samples;
            this.radius = radius;
        }

        public LocalLBPHistogram extractFeature(T detectedFace) {
            LocalLBPHistogram f = new LocalLBPHistogram();
            FImage face = this.aligner.align(detectedFace);
            FImage mask = this.aligner.getMask();
            f.initialise(face, mask, this.blocksX, this.blocksY, this.samples, this.radius);
            return f;
        }

        public void readBinary(DataInput in) throws IOException {
            String alignerClass = in.readUTF();
            this.aligner = (FaceAligner)IOUtils.newInstance((String)alignerClass);
            this.aligner.readBinary(in);
            this.blocksX = in.readInt();
            this.blocksY = in.readInt();
            this.radius = in.readInt();
            this.samples = in.readInt();
        }

        public byte[] binaryHeader() {
            return this.getClass().getName().getBytes();
        }

        public void writeBinary(DataOutput out) throws IOException {
            out.writeUTF(this.aligner.getClass().getName());
            this.aligner.writeBinary(out);
            out.writeInt(this.blocksX);
            out.writeInt(this.blocksY);
            out.writeInt(this.radius);
            out.writeInt(this.samples);
        }

        public String toString() {
            return String.format("LocalLBPHistogram.Factory[blocksX=%d,blocksY=%d,samples=%d,radius=%d]", this.blocksX, this.blocksY, this.samples, this.radius);
        }
    }
}

