/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.tracking;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.HaarCascadeDetector;
import org.openimaj.image.processing.face.tracking.FaceTracker;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.video.processing.tracking.BasicObjectTracker;

public class KLTHaarFaceTracker
implements FaceTracker<FImage> {
    private final HaarCascadeDetector faceDetector = new HaarCascadeDetector();
    private final List<BasicObjectTracker> trackers = new ArrayList<BasicObjectTracker>();
    private FImage previousFrame = null;
    private boolean retryFrame = false;
    private int forceRetry = -1;
    private int frameCounter = 0;
    private final float detectionScalar = 1.2f;

    public KLTHaarFaceTracker(int minSize) {
        this.faceDetector.setMinSize(minSize);
    }

    private List<DetectedFace> detectFaces(FImage img) {
        return this.faceDetector.detectFaces(img);
    }

    @Override
    public List<DetectedFace> trackFace(FImage img) {
        List<Object> detectedFaces = new ArrayList();
        if (this.forceRetry != -1 && this.frameCounter % this.forceRetry == 0) {
            this.trackers.clear();
        }
        if (this.previousFrame == null || this.trackers.size() == 0) {
            List<DetectedFace> faces = this.detectFaces(img);
            for (DetectedFace face : faces) {
                BasicObjectTracker faceTracker = new BasicObjectTracker();
                Rectangle r = face.getBounds();
                r.scaleCentroid(this.detectionScalar);
                faceTracker.initialiseTracking(r, img);
                this.trackers.add(faceTracker);
                this.previousFrame = img;
            }
            detectedFaces = faces;
        } else if (this.previousFrame != null) {
            Iterator<BasicObjectTracker> i = this.trackers.iterator();
            while (i.hasNext()) {
                BasicObjectTracker tracker = i.next();
                if (tracker.trackObject(img).size() == 0) {
                    i.remove();
                    continue;
                }
                detectedFaces.add(new DetectedFace(tracker.getFeatureList().getBounds(), (FImage)img.extractROI(tracker.getFeatureList().getBounds()), tracker.getFeatureList().countRemainingFeatures()));
                this.previousFrame = img;
            }
            if (this.trackers.size() == 0 && !this.retryFrame) {
                this.retryFrame = true;
                detectedFaces = this.trackFace(img);
            }
        }
        ++this.frameCounter;
        this.retryFrame = false;
        return detectedFaces;
    }

    public int getForceRetry() {
        return this.forceRetry;
    }

    public void setForceRetry(int forceRetry) {
        this.forceRetry = forceRetry;
    }
}

