/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.tracking.clm;

import Jama.Matrix;
import com.jsaragih.CLM;
import com.jsaragih.FDet;
import com.jsaragih.IO;
import com.jsaragih.MFCheck;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.openimaj.image.FImage;
import org.openimaj.image.analysis.algorithm.FourierTemplateMatcher;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

public class MultiTracker {
    private static final double TSCALE = 0.3;
    public List<TrackedFace> trackedFaces = new ArrayList<TrackedFace>();
    private TrackerVars initialTracker = null;
    private long framesSinceLastDetection;
    private FImage currentFrame;
    private FImage small_;

    public MultiTracker(CLM clm, FDet fdet, MFCheck fcheck, Matrix rshape, double[] simil) {
        this.initialTracker = new TrackerVars();
        this.initialTracker.clm = clm;
        this.initialTracker.clm._pdm.identity(clm._plocal, clm._pglobl);
        this.initialTracker.faceDetector = fdet;
        this.initialTracker.failureCheck = fcheck;
        this.initialTracker.referenceShape = rshape.copy();
        this.initialTracker.similarity = simil;
        this.initialTracker.shape = new Matrix(2 * clm._pdm.nPoints(), 1);
        this.framesSinceLastDetection = -1L;
    }

    public MultiTracker(TrackerVars tv) {
        this.initialTracker = tv;
        this.framesSinceLastDetection = -1L;
    }

    protected MultiTracker() {
    }

    public void frameReset() {
        this.framesSinceLastDetection = -1L;
        this.trackedFaces.clear();
    }

    public int track(FImage im, int[] wSize, int fpd, int nIter, double clamp, double fTol, boolean fcheck, float searchAreaSize) {
        this.currentFrame = im;
        if (this.framesSinceLastDetection < 0L || fpd >= 0 && (long)fpd < this.framesSinceLastDetection) {
            this.framesSinceLastDetection = 0L;
            List RL = this.initialTracker.faceDetector.detect(this.currentFrame);
            if (this.trackedFaces.size() == 0) {
                for (Object r : RL) {
                    this.trackedFaces.add(new TrackedFace((Rectangle)r, this.initialTracker));
                }
            } else {
                this.trackRedetect(this.currentFrame, searchAreaSize);
                int sz = this.trackedFaces.size();
                for (Rectangle r : RL) {
                    boolean found = false;
                    for (int i = 0; i < sz; ++i) {
                        if (!(r.percentageOverlap(this.trackedFaces.get((int)i).redetectedBounds) > 0.5)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    this.trackedFaces.add(new TrackedFace(r, this.initialTracker));
                }
            }
        } else {
            this.trackRedetect(this.currentFrame, searchAreaSize);
        }
        if (this.trackedFaces.size() == 0) {
            return -1;
        }
        boolean resize = true;
        Iterator<TrackedFace> iterator = this.trackedFaces.iterator();
        while (iterator.hasNext()) {
            TrackedFace f = iterator.next();
            if (f.redetectedBounds.width == 0.0f || f.redetectedBounds.height == 0.0f) {
                iterator.remove();
                this.framesSinceLastDetection = -1L;
                continue;
            }
            if (f.gen) {
                this.initShape(f.redetectedBounds, f.shape, f.referenceShape);
                f.clm._pdm.calcParams(f.shape, f.clm._plocal, f.clm._pglobl);
            } else {
                double tx = f.redetectedBounds.x - f.lastMatchBounds.x;
                double ty = f.redetectedBounds.y - f.lastMatchBounds.y;
                double[] dArray = f.clm._pglobl.getArray()[4];
                dArray[0] = dArray[0] + tx;
                double[] dArray2 = f.clm._pglobl.getArray()[5];
                dArray2[0] = dArray2[0] + ty;
                resize = false;
            }
            f.clm.fit(this.currentFrame, wSize, nIter, clamp, fTol);
            f.clm._pdm.calcShape2D(f.shape, f.clm._plocal, f.clm._pglobl);
            if (fcheck && !this.initialTracker.failureCheck.check(f.clm.getViewIdx(), this.currentFrame, f.shape)) {
                iterator.remove();
                continue;
            }
            f.lastMatchBounds = this.updateTemplate(f, this.currentFrame, f.shape, resize);
            if (f.lastMatchBounds.width != 0.0f && f.lastMatchBounds.height != 0.0f) continue;
            iterator.remove();
            this.framesSinceLastDetection = -1L;
        }
        if (this.trackedFaces.size() == 0) {
            return -1;
        }
        ++this.framesSinceLastDetection;
        return 0;
    }

    public void initShape(Rectangle r, Matrix shape, Matrix _rshape) {
        assert (shape.getRowDimension() == _rshape.getRowDimension() && shape.getColumnDimension() == _rshape.getColumnDimension());
        int n = _rshape.getRowDimension() / 2;
        double a = (double)r.width * Math.cos(this.initialTracker.similarity[1]) * this.initialTracker.similarity[0] + 1.0;
        double b = (double)r.width * Math.sin(this.initialTracker.similarity[1]) * this.initialTracker.similarity[0];
        double tx = (double)(r.x + (float)((int)(r.width / 2.0f))) + (double)r.width * this.initialTracker.similarity[2];
        double ty = (double)(r.y + (float)((int)(r.height / 2.0f))) + (double)r.height * this.initialTracker.similarity[3];
        double[][] s = _rshape.getArray();
        double[][] d = shape.getArray();
        for (int i = 0; i < n; ++i) {
            d[i][0] = a * s[i][0] - b * s[i + n][0] + tx;
            d[i + n][0] = b * s[i][0] + a * s[i + n][0] + ty;
        }
    }

    private void trackRedetect(FImage im, float searchAreaSize) {
        int ww = im.width;
        int hh = im.height;
        this.small_ = ResizeProcessor.resample((FImage)im, (int)((int)(0.3 * (double)ww)), (int)((int)(0.3 * (double)hh)));
        for (TrackedFace f : this.trackedFaces) {
            f.gen = false;
            Rectangle searchAreaBounds = f.lastMatchBounds.clone();
            searchAreaBounds.scale(0.3f);
            searchAreaBounds.scaleCentroid(searchAreaSize);
            searchAreaBounds = searchAreaBounds.overlapping(this.small_.getBounds()) != null ? searchAreaBounds.overlapping(this.small_.getBounds()) : this.small_.getBounds();
            FImage searchArea = (FImage)this.small_.extractROI(searchAreaBounds);
            FourierTemplateMatcher matcher = new FourierTemplateMatcher(f.templateImage, FourierTemplateMatcher.Mode.NORM_CORRELATION_COEFFICIENT);
            matcher.analyseImage(searchArea);
            float[][] ncc_ = matcher.getResponseMap().pixels;
            f.redetectedBounds = f.templateImage.getBounds();
            int h = searchArea.height - f.templateImage.height + 1;
            int w = searchArea.width - f.templateImage.width + 1;
            float vb = -2.0f;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    float v = ncc_[y][x];
                    if (!(v > vb)) continue;
                    vb = v;
                    f.redetectedBounds.x = (float)x + searchAreaBounds.x;
                    f.redetectedBounds.y = (float)y + searchAreaBounds.y;
                }
            }
            f.redetectedBounds.scale(3.3333333f);
        }
    }

    protected Rectangle updateTemplate(TrackedFace f, FImage im, Matrix s, boolean resize) {
        int n = s.getRowDimension() / 2;
        double[][] sv = s.getArray();
        double xmax = sv[0][0];
        double ymax = sv[n][0];
        double xmin = sv[0][0];
        double ymin = sv[n][0];
        for (int i = 0; i < n; ++i) {
            double vx = sv[i][0];
            double vy = sv[i + n][0];
            xmax = Math.max(xmax, vx);
            ymax = Math.max(ymax, vy);
            xmin = Math.min(xmin, vx);
            ymin = Math.min(ymin, vy);
        }
        if (xmin < 0.0 || ymin < 0.0 || xmax >= (double)im.width || ymax >= (double)im.height || Double.isNaN(xmin) || Double.isInfinite(xmin) || Double.isNaN(xmax) || Double.isInfinite(xmax) || Double.isNaN(ymin) || Double.isInfinite(ymin) || Double.isNaN(ymax) || Double.isInfinite(ymax)) {
            return new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        Rectangle R = new Rectangle((float)Math.floor(xmin *= 0.3), (float)Math.floor(ymin *= 0.3), (float)Math.ceil((xmax *= 0.3) - xmin), (float)Math.ceil((ymax *= 0.3) - ymin));
        int ww = im.width;
        int hh = im.height;
        if (resize) {
            this.small_ = ResizeProcessor.resample((FImage)im, (int)((int)(0.3 * (double)ww)), (int)((int)(0.3 * (double)hh)));
        }
        f.templateImage = (FImage)this.small_.extractROI(R);
        R.x = (float)((double)R.x * 3.3333333333333335);
        R.y = (float)((double)R.y * 3.3333333333333335);
        R.width = (float)((double)R.width * 3.3333333333333335);
        R.height = (float)((double)R.height * 3.3333333333333335);
        return R;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackerVars load(String fname) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fname));
            Scanner sc = new Scanner(br);
            TrackerVars trackerVars = MultiTracker.read(sc, true);
            return trackerVars;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrackerVars load(InputStream in) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in));
            Scanner sc = new Scanner(br);
            TrackerVars trackerVars = MultiTracker.read(sc, true);
            return trackerVars;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static TrackerVars read(Scanner s, boolean readType) {
        if (readType) {
            int type = s.nextInt();
            assert (type == IO.Types.TRACKER.ordinal());
        }
        TrackerVars trackerVars = new TrackerVars();
        trackerVars.clm = CLM.read((Scanner)s, (boolean)true);
        trackerVars.faceDetector = FDet.read((Scanner)s, (boolean)true);
        trackerVars.failureCheck = MFCheck.read((Scanner)s, (boolean)true);
        trackerVars.referenceShape = IO.readMat((Scanner)s);
        trackerVars.similarity = new double[]{s.nextDouble(), s.nextDouble(), s.nextDouble(), s.nextDouble()};
        trackerVars.shape = new Matrix(2 * trackerVars.clm._pdm.nPoints(), 1);
        trackerVars.clm._pdm.identity(trackerVars.clm._plocal, trackerVars.clm._pglobl);
        return trackerVars;
    }

    public TrackerVars getInitialVars() {
        return this.initialTracker;
    }

    public static class TrackerVars {
        public CLM clm;
        public Matrix shape;
        public Matrix referenceShape;
        public FDet faceDetector;
        public MFCheck failureCheck;
        double[] similarity;
    }

    public static class TrackedFace
    extends DetectedFace {
        public CLM clm;
        public Matrix shape;
        public Matrix referenceShape;
        public FImage templateImage;
        public Rectangle lastMatchBounds;
        public Rectangle redetectedBounds;
        protected boolean gen = true;

        public TrackedFace(Rectangle r, TrackerVars tv) {
            this.redetectedBounds = r;
            this.clm = tv.clm.copy();
            this.shape = tv.shape.copy();
            this.referenceShape = tv.referenceShape.copy();
        }

        @Override
        public Rectangle getBounds() {
            return this.lastMatchBounds;
        }

        public String toString() {
            return "Face[" + (this.redetectedBounds == null ? "null" : this.redetectedBounds.toString()) + "]";
        }
    }
}

