/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.gradient.binning;

import org.openimaj.image.analysis.algorithm.histogram.WindowedHistogramExtractor;
import org.openimaj.image.analysis.algorithm.histogram.binning.SpatialBinningStrategy;
import org.openimaj.image.feature.dense.gradient.binning.FixedHOGStrategy;
import org.openimaj.math.geometry.shape.Rectangle;
import org.openimaj.math.statistics.distribution.Histogram;

public class FlexibleHOGStrategy
implements SpatialBinningStrategy {
    int numCellsX = 8;
    int numCellsY = 16;
    int cellsPerBlockX = 2;
    int cellsPerBlockY = 2;
    FixedHOGStrategy.BlockNormalisation norm = FixedHOGStrategy.BlockNormalisation.L2;
    private int numBlocksX;
    private int numBlocksY;
    private int blockLength;
    private int blockArea;
    private int blockStepX;
    private int blockStepY;
    private transient Histogram[][] blocks;
    private transient Histogram[][] cells;

    public FlexibleHOGStrategy(int numCellsX, int numCellsY, int cellsPerBlock) {
        this(numCellsX, numCellsY, cellsPerBlock, 1, FixedHOGStrategy.BlockNormalisation.L2);
    }

    public FlexibleHOGStrategy(int numCellsX, int numCellsY, int cellsPerBlock, FixedHOGStrategy.BlockNormalisation norm) {
        this(numCellsX, numCellsY, cellsPerBlock, 1, norm);
    }

    public FlexibleHOGStrategy(int numCellsX, int numCellsY, int cellsPerBlock, int blockStep, FixedHOGStrategy.BlockNormalisation norm) {
        this(numCellsX, numCellsY, cellsPerBlock, cellsPerBlock, blockStep, blockStep, norm);
    }

    public FlexibleHOGStrategy(int numCellsX, int numCellsY, int cellsPerBlockX, int cellsPerBlockY, int blockStepX, int blockStepY, FixedHOGStrategy.BlockNormalisation norm) {
        this.numCellsX = numCellsX;
        this.numCellsY = numCellsY;
        this.cellsPerBlockX = cellsPerBlockX;
        this.cellsPerBlockY = cellsPerBlockY;
        this.norm = norm;
        this.blockStepX = blockStepX;
        this.blockStepY = blockStepY;
        this.numBlocksX = 1 + (numCellsX - cellsPerBlockX) / blockStepX;
        this.numBlocksY = 1 + (numCellsY - cellsPerBlockY) / blockStepY;
    }

    public Histogram extract(WindowedHistogramExtractor binnedData, Rectangle region, Histogram output) {
        int j;
        if (this.cells == null || ((double[])this.cells[0][0].values).length != binnedData.getNumBins()) {
            int i;
            this.cells = new Histogram[this.numCellsY][this.numCellsX];
            this.blocks = new Histogram[this.numBlocksY][this.numBlocksX];
            for (j = 0; j < this.numCellsY; ++j) {
                for (i = 0; i < this.numCellsX; ++i) {
                    this.cells[j][i] = new Histogram(binnedData.getNumBins());
                }
            }
            for (j = 0; j < this.numBlocksY; ++j) {
                for (i = 0; i < this.numBlocksX; ++i) {
                    this.blocks[j][i] = new Histogram(binnedData.getNumBins() * this.cellsPerBlockX * this.cellsPerBlockY);
                }
            }
            this.blockLength = ((double[])this.blocks[0][0].values).length;
            this.blockArea = this.cellsPerBlockX * this.cellsPerBlockY;
        }
        this.computeCells(binnedData, region);
        this.computeBlocks(this.cells);
        if (output == null || ((double[])output.values).length != this.blocks[0].length * this.blocks.length * this.blockLength) {
            output = new Histogram(this.blocks[0].length * this.blocks.length * this.blockLength);
        }
        int k = 0;
        for (j = 0; j < this.blocks.length; ++j) {
            int i = 0;
            while (i < this.blocks[0].length) {
                this.norm.normalise(this.blocks[j][i], this.blockArea);
                System.arraycopy(this.blocks[j][i].values, 0, output.values, k * this.blockLength, this.blockLength);
                ++i;
                ++k;
            }
        }
        return output;
    }

    private void computeBlocks(Histogram[][] cells) {
        for (int y = 0; y < this.numBlocksY; ++y) {
            for (int x = 0; x < this.numBlocksX; ++x) {
                double[] blockData = (double[])this.blocks[y][x].values;
                int k = 0;
                for (int j = 0; j < this.cellsPerBlockY; ++j) {
                    for (int i = 0; i < this.cellsPerBlockX; ++i) {
                        double[] cellData = (double[])cells[y * this.blockStepY + j][x * this.blockStepX + i].values;
                        System.arraycopy(cellData, 0, blockData, k, cellData.length);
                        k += cellData.length;
                    }
                }
            }
        }
    }

    private void computeCells(WindowedHistogramExtractor binnedData, Rectangle region) {
        int cellWidth = (int)(region.width / (float)this.numCellsX);
        int cellHeight = (int)(region.height / (float)this.numCellsY);
        int j = 0;
        int y = (int)region.y;
        while (j < this.numCellsY) {
            int i = 0;
            int x = (int)region.x;
            while (i < this.numCellsX) {
                binnedData.computeHistogram(x, y, cellWidth, cellHeight, this.cells[j][i]);
                this.cells[j][i].normaliseL2();
                ++i;
                x += cellWidth;
            }
            ++j;
            y += cellHeight;
        }
    }
}

