/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.colour.Transforms;
import org.openimaj.image.mask.AbstractMaskedObject;

public class HueStats
extends AbstractMaskedObject<FImage>
implements ImageAnalyser<MBFImage>,
FeatureVectorProvider<DoubleFV> {
    double mean_x = 0.0;
    double m2_x = 0.0;
    double mean_y = 0.0;
    double m2_y = 0.0;
    int n = 0;

    public HueStats() {
    }

    public HueStats(FImage mask) {
        super((Image)mask);
    }

    public void analyseImage(MBFImage image) {
        this.mean_x = 0.0;
        this.m2_x = 0.0;
        this.mean_y = 0.0;
        this.m2_y = 0.0;
        this.n = 0;
        FImage hue = Transforms.calculateHue((MBFImage)image);
        for (int j = 0; j < hue.height; ++j) {
            for (int i = 0; i < hue.width; ++i) {
                if (this.mask != null && ((FImage)this.mask).pixels[j][i] == 0.0f) continue;
                double angle = hue.pixels[j][i];
                double x = Math.cos(Math.PI * 2 * angle);
                double y = Math.sin(Math.PI * 2 * angle);
                ++this.n;
                double delta_x = x - this.mean_x;
                double delta_y = y - this.mean_y;
                this.mean_x += delta_x / (double)this.n;
                this.mean_y += delta_y / (double)this.n;
                this.m2_x += delta_x * (x - this.mean_x);
                this.m2_y += delta_y * (y - this.mean_y);
            }
        }
    }

    public double getMeanHue() {
        return Math.atan2(this.mean_y, this.mean_x);
    }

    public double getHueVariance() {
        double var_x = this.m2_x / (double)this.n;
        double var_y = this.m2_y / (double)this.n;
        return var_y * var_x;
    }

    public ToneAttr getTone() {
        return ToneAttr.getAttr(this.getMeanHue(), this.getHueVariance());
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.getMeanHue(), this.getHueVariance()});
    }

    public static enum ToneAttr {
        SEPIA,
        BLACK_AND_WHITE,
        COLOR;


        public static ToneAttr getAttr(double mean, double var) {
            if (var < 5.0E-4) {
                if (mean > -0.1 && mean < 0.1) {
                    return BLACK_AND_WHITE;
                }
                if (mean > 0.6 && mean < 0.8) {
                    return SEPIA;
                }
            }
            return COLOR;
        }
    }
}

