/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;

@Reference(type=ReferenceType.Inproceedings, author={"Che-Hua Yeh", "Yuan-Chen Ho", "Brian A. Barsky", "Ming Ouhyoung"}, title="Personalized Photograph Ranking and Selection System", year="2010", booktitle="Proceedings of ACM Multimedia", pages={"211", "220"}, month="October", customData={"location", "Florence, Italy"})
public class WeberContrast
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    double contrast;

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.contrast});
    }

    public void analyseImage(FImage image) {
        int x;
        int y;
        int width = image.width;
        int height = image.height;
        double avg = 0.0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                avg += (double)image.pixels[y][x];
            }
        }
        avg /= (double)(width * height);
        this.contrast = 0.0;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                this.contrast += ((double)image.pixels[y][x] - avg) / avg;
            }
        }
        this.contrast /= (double)(height * width);
    }

    public double getContrast() {
        return this.contrast;
    }
}

