/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.patch;

import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.model.ImageClassificationModel;
import org.openimaj.util.pair.IndependentPair;

public abstract class PatchClassificationModel<Q, T extends Image<Q, T>>
implements ImageClassificationModel<T> {
    private static final long serialVersionUID = 1L;
    protected int patchHeight;
    protected int patchWidth;

    public PatchClassificationModel(int patchWidth, int patchHeight) {
        this.patchHeight = patchHeight;
        this.patchWidth = patchWidth;
    }

    public abstract float classifyPatch(T var1);

    @Override
    public FImage classifyImage(T im) {
        FImage out = new FImage(im.getWidth(), im.getHeight());
        Image roi = im.newInstance(this.patchWidth, this.patchHeight);
        int hh = this.patchHeight / 2;
        int hw = this.patchWidth / 2;
        for (int y = hh; y < im.getHeight() - (this.patchHeight - hh); ++y) {
            for (int x = hw; x < im.getWidth() - (this.patchWidth - hw); ++x) {
                im.extractROI(x - hw, y - hh, roi);
                out.pixels[y][x] = this.classifyPatch(roi);
            }
        }
        return out;
    }

    public abstract PatchClassificationModel<Q, T> clone();

    protected abstract T[] getArray(int var1);

    public boolean estimate(List<? extends IndependentPair<T, FImage>> data) {
        Image[] samples = this.getArray(data.size());
        for (int i = 0; i < data.size(); ++i) {
            samples[i] = (Image)data.get(i).firstObject();
        }
        this.learnModel(samples);
        return true;
    }

    public int numItemsToEstimate() {
        return 1;
    }

    public FImage predict(T data) {
        return this.classifyImage(data);
    }
}

