/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.pixel;

import org.openimaj.image.MBFImage;
import org.openimaj.image.model.pixel.MBFPixelClassificationModel;

public class OrthotopePixelModel
extends MBFPixelClassificationModel {
    private static final long serialVersionUID = 1L;
    protected float[] min;
    protected float[] max;

    public OrthotopePixelModel(int ndims) {
        super(ndims);
        this.min = new float[ndims];
        this.max = new float[ndims];
    }

    public OrthotopePixelModel(float[] minCoords, float[] maxCoords) {
        super(minCoords.length);
        if (minCoords.length != maxCoords.length) {
            throw new IllegalArgumentException("minimum and maximum coordinates must have the same number of dimensions.");
        }
        this.min = minCoords;
        this.max = maxCoords;
    }

    @Override
    protected float classifyPixel(Float[] pix) {
        for (int i = 0; i < this.ndims; ++i) {
            if (!(pix[i].floatValue() > this.max[i]) && !(pix[i].floatValue() < this.min[i])) continue;
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public OrthotopePixelModel clone() {
        OrthotopePixelModel newModel = new OrthotopePixelModel(this.ndims);
        newModel.min = (float[])this.min.clone();
        newModel.max = (float[])this.max.clone();
        return newModel;
    }

    public void learnModel(MBFImage ... images) {
        for (int i = 0; i < this.ndims; ++i) {
            this.min[i] = Float.MAX_VALUE;
            this.max[i] = Float.MIN_VALUE;
        }
        for (MBFImage image : images) {
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    Float[] pixel = image.getPixel(x, y);
                    for (int i = 0; i < this.ndims; ++i) {
                        if (pixel[i].floatValue() > this.max[i]) {
                            this.max[i] = pixel[i].floatValue();
                        }
                        if (!(pixel[i].floatValue() < this.min[i])) continue;
                        this.min[i] = pixel[i].floatValue();
                    }
                }
            }
        }
    }
}

