/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.segmentation;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.FloatFVComparator;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.segmentation.Segmenter;
import org.openimaj.knn.FloatNearestNeighboursExact;
import org.openimaj.knn.NearestNeighboursFactory;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.kmeans.FloatKMeans;
import org.openimaj.ml.clustering.kmeans.KMeansConfiguration;

public class KMColourSegmenter
implements Segmenter<MBFImage> {
    private static final int DEFAULT_MAX_ITERS = 100;
    protected ColourSpace colourSpace;
    protected float[] scaling;
    protected FloatKMeans kmeans;

    public KMColourSegmenter(ColourSpace colourSpace, int K) {
        this(colourSpace, null, K, null, 100);
    }

    public KMColourSegmenter(ColourSpace colourSpace, int K, FloatFVComparator distance) {
        this(colourSpace, null, K, distance, 100);
    }

    public KMColourSegmenter(ColourSpace colourSpace, float[] scaling, int K, FloatFVComparator distance) {
        this(colourSpace, scaling, K, distance, 100);
    }

    public KMColourSegmenter(ColourSpace colourSpace, float[] scaling, int K, FloatFVComparator distance, int maxIters) {
        if (scaling != null && scaling.length < colourSpace.getNumBands()) {
            throw new IllegalArgumentException("Scaling vector must have the same length as the number of dimensions of the target colourspace (or more)");
        }
        this.colourSpace = colourSpace;
        this.scaling = scaling;
        KMeansConfiguration conf = new KMeansConfiguration(K, (NearestNeighboursFactory)new FloatNearestNeighboursExact.Factory(distance), maxIters);
        this.kmeans = new FloatKMeans(conf);
    }

    protected float[][] imageToVector(MBFImage image) {
        int height = image.getHeight();
        int width = image.getWidth();
        int bands = image.numBands();
        float[][] f = new float[height * width][bands];
        for (int b = 0; b < bands; ++b) {
            float[][] band = ((FImage)image.getBand((int)b)).pixels;
            float w = this.scaling == null ? 1.0f : this.scaling[b];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    f[x + y * width][b] = band[y][x] * w;
                }
            }
        }
        return f;
    }

    @Override
    public List<? extends PixelSet> segment(MBFImage image) {
        MBFImage input = ColourSpace.convert((MBFImage)image, (ColourSpace)this.colourSpace);
        float[][] imageData = this.imageToVector(input);
        FloatKMeans.Result result = this.kmeans.cluster(imageData);
        ArrayList<PixelSet> out = new ArrayList<PixelSet>(this.kmeans.getConfiguration().getK());
        for (int i = 0; i < this.kmeans.getConfiguration().getK(); ++i) {
            out.add(new PixelSet());
        }
        HardAssigner assigner = result.defaultHardAssigner();
        int height = image.getHeight();
        int width = image.getWidth();
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                float[] pixel = imageData[i];
                int centroid = assigner.assign((Object)pixel);
                ((PixelSet)out.get(centroid)).addPixel(x, y);
                ++x;
                ++i;
            }
        }
        return out;
    }
}

