/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.segmentation;

import gnu.trove.map.hash.TFloatObjectHashMap;
import java.util.Arrays;
import java.util.List;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.processor.Processor;
import org.openimaj.image.segmentation.Segmenter;

public class ThresholdSegmenter
implements Segmenter<FImage> {
    Processor<FImage> thresholder;

    public ThresholdSegmenter(Processor<FImage> thresholder) {
        this.thresholder = thresholder;
    }

    @Override
    public List<? extends PixelSet> segment(FImage image) {
        FImage timg = (FImage)image.process(this.thresholder);
        TFloatObjectHashMap sets = new TFloatObjectHashMap();
        for (int y = 0; y < timg.height; ++y) {
            for (int x = 0; x < timg.width; ++x) {
                float p = image.getPixel(x, y).floatValue();
                PixelSet ps = (PixelSet)sets.get(p);
                if (ps == null) {
                    ps = new PixelSet();
                    sets.put(p, (Object)ps);
                }
                ps.addPixel(x, y);
            }
        }
        return Arrays.asList(sets.values());
    }
}

