/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.contour;

import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;

enum Direction {
    NORTH,
    NORTH_EAST,
    EAST,
    SOUTH_EAST,
    SOUTH,
    SOUTH_WEST,
    WEST,
    NORTH_WEST;

    static int[] dirx;
    static int[] diry;
    static Direction[] entry;
    static Direction[] ccentry;

    public Direction clockwise() {
        Direction[] vals = Direction.values();
        Direction dir = vals[(this.ordinal() + 1) % vals.length];
        return dir;
    }

    public Direction counterClockwise() {
        Direction[] vals = Direction.values();
        int desired = this.ordinal() - 1;
        Direction dir = vals[desired == -1 ? desired + vals.length : desired];
        return dir;
    }

    public Pixel active(FImage img, Pixel point) {
        int ord = this.ordinal();
        int yy = point.y + diry[ord];
        int xx = point.x + dirx[ord];
        if (xx < 0 || xx >= img.width || yy < 0 || yy >= img.height) {
            return null;
        }
        float pix = img.pixels[yy][xx];
        return pix != 0.0f ? new Pixel(xx, yy) : null;
    }

    public Direction clockwiseEntryDirection() {
        return entry[this.ordinal()];
    }

    public Direction counterClockwiseEntryDirection() {
        return ccentry[this.ordinal()];
    }

    public static Direction fromTo(Pixel from, Pixel to) {
        if (from.equals((Object)to)) {
            return null;
        }
        if (from.y == to.y) {
            if (from.x < to.x) {
                return EAST;
            }
            return WEST;
        }
        if (from.y < to.y) {
            if (from.x == to.x) {
                return SOUTH;
            }
            if (from.x < to.x) {
                return SOUTH_EAST;
            }
            return SOUTH_WEST;
        }
        if (from.x == to.x) {
            return NORTH;
        }
        if (from.x < to.x) {
            return NORTH_EAST;
        }
        return NORTH_WEST;
    }

    public Pixel pixel(Pixel from) {
        return new Pixel(from.x + dirx[this.ordinal()], from.y + diry[this.ordinal()]);
    }

    static {
        dirx = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        diry = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
        entry = new Direction[]{WEST, WEST, NORTH, NORTH, EAST, EAST, SOUTH, SOUTH};
        ccentry = new Direction[]{EAST, SOUTH, SOUTH, WEST, WEST, NORTH, NORTH, EAST};
    }
}

