/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.dense.binarypattern;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.pixel.Pixel;

@Reference(type=ReferenceType.Article, author={"Ojala, Timo", "Pietik\"{a}inen, Matti", "M\"{a}enp\"{a}\"{a}, Topi"}, title="Multiresolution Gray-Scale and Rotation Invariant Texture Classification with Local Binary Patterns", year="2002", journal="IEEE Trans. Pattern Anal. Mach. Intell.", pages={"971", "", "987"}, url="http://dx.doi.org/10.1109/TPAMI.2002.1017623", month="July", number="7", publisher="IEEE Computer Society", volume="24", customData={"date", "July 2002", "issn", "0162-8828", "numpages", "17", "doi", "10.1109/TPAMI.2002.1017623", "acmid", "628808", "address", "Washington, DC, USA"})
public class ExtendedLocalBinaryPattern
implements ImageAnalyser<FImage> {
    protected int[][] pattern;
    protected float radius;
    protected int samples;

    public ExtendedLocalBinaryPattern(float radius, int samples) {
        ExtendedLocalBinaryPattern.checkParams(radius, samples);
        this.radius = radius;
        this.samples = samples;
    }

    public static int[][] calculateLBP(FImage image, float radius, int samples) {
        ExtendedLocalBinaryPattern.checkParams(radius, samples);
        int[][] pattern = new int[image.height][image.width];
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                pattern[y][x] = ExtendedLocalBinaryPattern.calculateLBP(image, radius, samples, x, y);
            }
        }
        return pattern;
    }

    public static int calculateLBP(FImage image, float radius, int samples, int x, int y) {
        float centre = image.pixels[y][x];
        int pattern = 0;
        for (int i = 0; i < samples; ++i) {
            double dy;
            double dx = (double)(-radius) * Math.sin(Math.PI * 2 * (double)i / (double)samples);
            float pix = image.getPixelInterp((double)x + dx, (double)y + (dy = (double)radius * Math.cos(Math.PI * 2 * (double)i / (double)samples))).floatValue();
            if (!(pix - centre >= 0.0f)) continue;
            pattern = (int)((double)pattern + Math.pow(2.0, i));
        }
        return pattern;
    }

    public static int calculateLBP(FImage image, float radius, int samples, Pixel point) {
        return ExtendedLocalBinaryPattern.calculateLBP(image, radius, samples, point.x, point.y);
    }

    private static void checkParams(float radius, int samples) {
        if (radius <= 0.0f) {
            throw new IllegalArgumentException("radius must be greater than 0");
        }
        if (samples <= 1 || samples > 31) {
            throw new IllegalArgumentException("samples cannot be less than one or more than 31");
        }
    }

    public void analyseImage(FImage image) {
        this.pattern = ExtendedLocalBinaryPattern.calculateLBP(image, this.radius, this.samples);
    }

    public int[][] getPattern() {
        return this.pattern;
    }
}

