/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.global;

import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.mask.AbstractMaskedObject;
import org.openimaj.image.processing.convolution.AverageBoxFilter;
import org.openimaj.image.processing.convolution.Laplacian3x3;
import org.openimaj.image.processor.SinglebandImageProcessor;

@Reference(type=ReferenceType.Inproceedings, author={"Jose San Pedro", "Stefan Siersdorfer"}, title="Ranking and Classifying Attractiveness of Photos in Folksonomies", year="2009", booktitle="18th International World Wide Web Conference", pages={"771", "", "771"}, url="http://www2009.eprints.org/78/", month="April")
public class SharpnessVariation
extends AbstractMaskedObject<FImage>
implements ImageAnalyser<FImage>,
FeatureVectorProvider<DoubleFV> {
    private final Laplacian3x3 laplacian = new Laplacian3x3();
    private final AverageBoxFilter average = new AverageBoxFilter(3, 3);
    protected double sharpnessVariation;

    public SharpnessVariation() {
    }

    public SharpnessVariation(FImage mask) {
        super((Image)mask);
    }

    public DoubleFV getFeatureVector() {
        return new DoubleFV(new double[]{this.sharpnessVariation});
    }

    public void analyseImage(FImage image) {
        FImage limg = (FImage)image.process((SinglebandImageProcessor)this.laplacian);
        FImage aimg = (FImage)image.process((SinglebandImageProcessor)this.average);
        SummaryStatistics stats = new SummaryStatistics();
        for (int r = 0; r < limg.height; ++r) {
            for (int c = 0; c < limg.width; ++c) {
                if (this.mask != null && ((FImage)this.mask).pixels[r][c] == 0.0f || aimg.pixels[r][c] == 0.0f) continue;
                stats.addValue((double)Math.abs(limg.pixels[r][c] / aimg.pixels[r][c]));
            }
        }
        this.sharpnessVariation = stats.getStandardDeviation();
    }

    public double getSharpnessVariation() {
        return this.sharpnessVariation;
    }
}

