/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.statistics;

import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.statistics.AbstractPixelStatisticsModel;
import org.openimaj.math.statistics.distribution.MultidimensionalHistogram;
import org.openimaj.util.pair.Pair;

public class HistogramModel
extends AbstractPixelStatisticsModel
implements FeatureVectorProvider<MultidimensionalHistogram> {
    private static final long serialVersionUID = 1L;
    public MultidimensionalHistogram histogram;

    public HistogramModel(int ... nbins) {
        super(nbins.length);
        assert (nbins.length > 0);
        this.histogram = new MultidimensionalHistogram(nbins);
    }

    @Override
    public void estimateModel(MBFImage ... images) {
        this.reset();
        for (MBFImage im : images) {
            this.accum(im);
        }
        this.histogram.normalise();
    }

    protected void reset() {
        for (int i = 0; i < ((double[])this.histogram.values).length; ++i) {
            ((double[])this.histogram.values)[i] = 0.0;
        }
    }

    public Pair<float[]> colourRange(int index) {
        int[] coord = this.histogram.getCoordinates(index);
        float[] start = new float[coord.length];
        float[] end = new float[coord.length];
        int[] nbins = this.histogram.nbins;
        for (int i = 0; i < coord.length; ++i) {
            start[i] = (float)coord[i] / (float)nbins[i];
            end[i] = ((float)coord[i] + 1.0f) / (float)nbins[i];
        }
        return new Pair((Object)start, (Object)end);
    }

    public float[] colourAverage(int index) {
        int[] coord = this.histogram.getCoordinates(index);
        float[] average = new float[coord.length];
        int[] nbins = this.histogram.nbins;
        for (int i = 0; i < coord.length; ++i) {
            float start = (float)coord[i] / (float)nbins[i];
            float end = ((float)coord[i] + 1.0f) / (float)nbins[i];
            average[i] = (start + end) / 2.0f;
        }
        return average;
    }

    protected void accum(MBFImage im) {
        int height = im.getHeight();
        int width = im.getWidth();
        int[] bins = new int[this.ndims];
        float[][][] bands = new float[im.numBands()][][];
        for (int i = 0; i < bands.length; ++i) {
            bands[i] = ((FImage)im.getBand((int)i)).pixels;
        }
        int[] nbins = this.histogram.nbins;
        double[] values = (double[])this.histogram.values;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (int i = 0; i < this.ndims; ++i) {
                    bins[i] = (int)(bands[i][y][x] * (float)nbins[i]);
                    if (bins[i] < nbins[i]) continue;
                    bins[i] = nbins[i] - 1;
                }
                int bin = 0;
                for (int i = 0; i < this.ndims; ++i) {
                    int f = 1;
                    for (int j = 0; j < i; ++j) {
                        f *= nbins[j];
                    }
                    bin += f * bins[i];
                }
                int n = bin;
                values[n] = values[n] + 1.0;
            }
        }
    }

    public String toString() {
        return this.histogram.toString();
    }

    public HistogramModel clone() {
        HistogramModel model = new HistogramModel(new int[0]);
        model.histogram = this.histogram.clone();
        model.ndims = this.ndims;
        return model;
    }

    public MultidimensionalHistogram getFeatureVector() {
        return this.histogram;
    }
}

