/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.local.matcher.BasicMatcher;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.knn.approximate.ByteNearestNeighboursKDTree;
import org.openimaj.util.pair.Pair;

@References(references={@Reference(type=ReferenceType.Article, author={"David Lowe"}, title="Distinctive image features from scale-invariant keypoints", year="2004", journal="IJCV", pages={"91", "110"}, month="January", number="2", volume="60"), @Reference(type=ReferenceType.Inproceedings, author={"David Lowe"}, title="Object recognition from local scale-invariant features", year="1999", booktitle="Proc. of the International Conference on Computer Vision {ICCV}", pages={"1150", "1157"})})
public class FastBasicKeypointMatcher<T extends Keypoint>
extends BasicMatcher<T> {
    protected ByteNearestNeighboursKDTree modelKeypointsKNN;

    public FastBasicKeypointMatcher() {
        super(8);
    }

    public FastBasicKeypointMatcher(int threshold) {
        super(threshold);
    }

    @Override
    public boolean findMatches(List<T> keys1) {
        this.matches = new ArrayList();
        byte[][] data = new byte[keys1.size()][];
        for (int i = 0; i < keys1.size(); ++i) {
            data[i] = ((Keypoint)keys1.get((int)i)).ivec;
        }
        int[][] argmins = new int[keys1.size()][2];
        float[][] mins = new float[keys1.size()][2];
        this.modelKeypointsKNN.searchKNN((byte[][])data, 2, argmins, mins);
        for (int i = 0; i < keys1.size(); ++i) {
            float distsq1 = mins[i][0];
            float distsq2 = mins[i][1];
            if (!(100.0f * distsq1 < (float)(this.thresh * this.thresh) * distsq2)) continue;
            this.matches.add(new Pair(keys1.get(i), this.modelKeypoints.get(argmins[i][0])));
        }
        return true;
    }

    @Override
    public void setModelFeatures(List<T> modelkeys) {
        this.modelKeypoints = modelkeys;
        byte[][] data = new byte[modelkeys.size()][];
        for (int i = 0; i < modelkeys.size(); ++i) {
            data[i] = ((Keypoint)modelkeys.get((int)i)).ivec;
        }
        this.modelKeypointsKNN = new ByteNearestNeighboursKDTree((byte[][])data, 1, 100);
    }
}

