/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature.local.matcher;

import Jama.Matrix;
import java.util.List;
import java.util.Random;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.keypoints.Keypoint;
import org.openimaj.util.pair.Pair;

public class KeypointCorrespondenceTestHelper {
    public static Matrix generateMildTransform(FImage image) {
        return KeypointCorrespondenceTestHelper.generateMildTransform(image, new Random());
    }

    public static Matrix generateMildTransform(FImage image, Random seed) {
        double tenDegrees = 0.08726646259971647;
        return KeypointCorrespondenceTestHelper.generateRandomTransform((double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0, 0.0, 10.0, 0.0, Math.PI * 2, 1.0, 1.0, tenDegrees * 3.0, tenDegrees * 3.0, seed);
    }

    private static Matrix generateRandomTransform(double centerX, double centerY, double minTrans, double maxTrans, double minRot, double maxRot, double minScale, double maxScale, double maxSlantX, double maxSlantY, Random seed) {
        System.out.println("Generating random transform matrix");
        double transX = seed.nextDouble() * (maxTrans - minTrans) + minTrans;
        double transY = seed.nextDouble() * (maxTrans - minTrans) + minTrans;
        double rot = seed.nextDouble() * (maxRot - minRot) + minRot;
        double scale = seed.nextDouble() * (maxScale - minScale) + minScale;
        double slantX = seed.nextDouble() * maxSlantX;
        double slantY = seed.nextDouble() * maxSlantY;
        slantX = 1.0 - slantX / 1.5707963267948966;
        slantY = 1.0 - slantY / 1.5707963267948966;
        double[][][] extrema = new double[][][]{new double[][]{{0.0}, {0.0}, {1.0}}, new double[][]{{0.0}, {centerY * 2.0 * scale * slantY}, {1.0}}, new double[][]{{centerX * 2.0 * scale * slantX}, {0.0}, {1.0}}, new double[][]{{centerX * 2.0 * scale * slantX}, {centerY * 2.0 * scale * slantY}, {1.0}}};
        Matrix rotationMatrix = Matrix.constructWithCopy((double[][])new double[][]{{Math.cos(rot), -Math.sin(rot), 0.0}, {Math.sin(rot), Math.cos(rot), 0.0}, {0.0, 0.0, 1.0}});
        boolean unset = true;
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        for (double[][] ext : extrema) {
            Matrix tmp = rotationMatrix.times(Matrix.constructWithCopy((double[][])ext));
            if (unset) {
                minX = maxX = tmp.get(0, 0);
                maxY = minY = tmp.get(1, 0);
                unset = false;
                continue;
            }
            if (tmp.get(0, 0) > maxX) {
                maxX = tmp.get(0, 0);
            }
            if (tmp.get(1, 0) > maxY) {
                maxY = tmp.get(1, 0);
            }
            if (tmp.get(0, 0) < minX) {
                minX = tmp.get(0, 0);
            }
            if (!(tmp.get(1, 0) < minY)) continue;
            minY = tmp.get(1, 0);
        }
        double deCenterX = (maxX - minX) / 2.0;
        double deCenterY = (maxY - minY) / 2.0;
        Matrix centerTranslationMatrix = Matrix.constructWithCopy((double[][])new double[][]{{1.0, 0.0, -centerX * scale * slantX}, {0.0, 1.0, -centerY * scale * slantY}, {0.0, 0.0, 1.0}});
        Matrix translationMatrix = Matrix.constructWithCopy((double[][])new double[][]{{1.0, 0.0, transX * scale * slantX}, {0.0, 1.0, transY * scale * slantY}, {0.0, 0.0, 1.0}});
        Matrix decenterTranslationMatrix = Matrix.constructWithCopy((double[][])new double[][]{{1.0, 0.0, deCenterX}, {0.0, 1.0, deCenterY}, {0.0, 0.0, 1.0}});
        Matrix scaleMatrix = Matrix.constructWithCopy((double[][])new double[][]{{scale, 0.0, 0.0}, {0.0, scale, 0.0}, {0.0, 0.0, 1.0}});
        Matrix slantMatrix = Matrix.constructWithCopy((double[][])new double[][]{{slantX, 0.0, 0.0}, {0.0, slantY, 0.0}, {0.0, 0.0, 1.0}});
        return Matrix.identity((int)3, (int)3).times(translationMatrix).times(decenterTranslationMatrix).times(rotationMatrix).times(centerTranslationMatrix).times(slantMatrix).times(scaleMatrix);
    }

    public static float correspondance(List<Pair<Keypoint>> matches, Matrix transform) {
        return KeypointCorrespondenceTestHelper.correspondance(matches, transform, 1.0f);
    }

    public static float correspondance(List<Pair<Keypoint>> matches, Matrix transform, float scaleThreshold) {
        float total = 0.0f;
        for (Pair<Keypoint> pair : matches) {
            Keypoint originalKeypoint = (Keypoint)pair.firstObject();
            float currentScaleThreshold = scaleThreshold * originalKeypoint.scale;
            Keypoint transformedKeypoint = (Keypoint)pair.secondObject();
            Matrix originalKPMatrix = KeypointCorrespondenceTestHelper.keypointToMatrix(originalKeypoint);
            Matrix transformedKPMatrix = KeypointCorrespondenceTestHelper.keypointToMatrix(transformedKeypoint);
            Matrix originalTransformed = transform.times(originalKPMatrix);
            if (!(KeypointCorrespondenceTestHelper.distance(originalTransformed, transformedKPMatrix) < currentScaleThreshold)) continue;
            total += 1.0f;
        }
        return total;
    }

    private static Matrix keypointToMatrix(Keypoint kp) {
        return Matrix.constructWithCopy((double[][])new double[][]{{kp.x}, {kp.y}, {1.0}});
    }

    private static float distance(Matrix a, Matrix b) {
        return (float)a.minus(b).norm2();
    }
}

