/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.descriptor.gradient;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProvider;
import org.openimaj.image.feature.local.descriptor.gradient.GradientFeatureProviderFactory;
import org.openimaj.util.array.ArrayUtils;

@Reference(type=ReferenceType.Inproceedings, author={"Cui, Yan", "Hasler, Nils", "Thorm\"{a}hlen, Thorsten", "Seidel, Hans-Peter"}, title="Scale Invariant Feature Transform with Irregular Orientation Histogram Binning", year="2009", booktitle="Proceedings of the 6th International Conference on Image Analysis and Recognition", pages={"258", "", "267"}, publisher="Springer-Verlag", series="ICIAR '09", customData={"Address", "Berlin, Heidelberg"})
public class IrregularBinningSIFTFeatureProvider
implements GradientFeatureProvider,
GradientFeatureProviderFactory {
    private static final float TWO_PI_FLOAT = (float)Math.PI * 2;
    private static final float FULL_SIZE = 1.0f;
    private static final float HALF_SIZE = 0.0f;
    private static final float QUARTER_SIZE = 0.0f;
    private static final float THREE_QUARTER_SIZE = 0.0f;
    private static final float THREE_EIGHTHS_SIZE = 0.0f;
    private static final float FIVE_EIGHTHS_SIZE = 0.0f;
    protected int numOriBins = 8;
    protected float valueThreshold = 0.2f;
    protected float patchOrientation;
    protected float[] vec;

    public IrregularBinningSIFTFeatureProvider() {
        this.vec = new float[16 * this.numOriBins];
    }

    public IrregularBinningSIFTFeatureProvider(int numOriBins) {
        this.numOriBins = numOriBins;
        this.vec = new float[16 * numOriBins];
    }

    public IrregularBinningSIFTFeatureProvider(int numOriBins, float valueThreshold) {
        this.numOriBins = numOriBins;
        this.valueThreshold = valueThreshold;
        this.vec = new float[16 * numOriBins];
    }

    @Override
    public void addSample(float x, float y, float gradmag, float gradori) {
        float f;
        float ori = gradori - this.patchOrientation;
        ori %= (float)Math.PI * 2;
        float f2 = ori = f >= 0.0f ? ori : ori + (float)Math.PI * 2;
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(0, 0, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(0, 1, ori, gradmag);
        }
        if (x >= 0.0f && x < 1.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(0, 2, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(0, 3, ori, gradmag);
        }
        if (x >= 0.0f && x < 1.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(1, 0, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 1.0f) {
            this.assignOri(1, 1, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 1.0f) {
            this.assignOri(1, 2, ori, gradmag);
        }
        if (x >= 0.0f && x < 1.0f && y >= 0.0f && y < 1.0f) {
            this.assignOri(1, 3, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(2, 0, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(2, 1, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(2, 2, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(2, 3, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(3, 0, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(3, 1, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(3, 2, ori, gradmag);
        }
        if (x >= 0.0f && x < 0.0f && y >= 0.0f && y < 0.0f) {
            this.assignOri(3, 3, ori, gradmag);
        }
    }

    protected void assignOri(int r, int c, float orif, float mag) {
        float oval = (float)((double)((float)this.numOriBins * orif) / (Math.PI * 2));
        int oi = (int)(oval >= 0.0f ? oval : oval - 1.0f);
        float ofrac = oval - (float)oi;
        for (int or = 0; or < 2; ++or) {
            int oindex = oi + or;
            if (oindex >= this.numOriBins) {
                oindex = 0;
            }
            float oweight = mag * (or == 0 ? 1.0f - ofrac : ofrac);
            int n = 4 * this.numOriBins * r + this.numOriBins * c + oindex;
            this.vec[n] = this.vec[n] + oweight;
        }
    }

    @Override
    public OrientedFeatureVector getFeatureVector() {
        ArrayUtils.normalise((float[])this.vec);
        boolean changed = false;
        for (int i = 0; i < this.vec.length; ++i) {
            if (!(this.vec[i] > this.valueThreshold)) continue;
            this.vec[i] = this.valueThreshold;
            changed = true;
        }
        if (changed) {
            ArrayUtils.normalise((float[])this.vec);
        }
        OrientedFeatureVector fv = new OrientedFeatureVector(this.vec.length, this.patchOrientation);
        for (int i = 0; i < this.vec.length; ++i) {
            int intval = (int)(512.0 * (double)this.vec[i]);
            ((byte[])fv.values)[i] = (byte)(Math.min(255, intval) - 128);
        }
        return fv;
    }

    @Override
    public void setPatchOrientation(float patchOrientation) {
        this.patchOrientation = patchOrientation;
    }

    @Override
    public GradientFeatureProvider newProvider() {
        return new IrregularBinningSIFTFeatureProvider(this.numOriBins, this.valueThreshold);
    }

    @Override
    public float getOversamplingAmount() {
        return 0.0f;
    }
}

