/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.collector;

import org.openimaj.feature.FeatureVector;
import org.openimaj.feature.local.LocalFeature;
import org.openimaj.feature.local.LocalFeatureImpl;
import org.openimaj.feature.local.Location;
import org.openimaj.feature.local.ScaleSpaceLocation;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.Octave;
import org.openimaj.image.feature.local.detector.dog.collector.AbstractOctaveLocalFeatureCollector;
import org.openimaj.image.feature.local.detector.pyramid.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.extraction.FeatureVectorExtractor;
import org.openimaj.image.feature.local.extraction.ScaleSpaceImageExtractorProperties;

public class ConcreteOctaveLocalFeatureCollector<OCTAVE extends Octave<?, ?, IMAGE>, FE extends FeatureVectorExtractor<?, ScaleSpaceImageExtractorProperties<IMAGE>>, IMAGE extends Image<?, IMAGE>>
extends AbstractOctaveLocalFeatureCollector<OCTAVE, FE, LocalFeature<?, ?>, IMAGE> {
    protected ScaleSpaceImageExtractorProperties<IMAGE> extractionProperties = new ScaleSpaceImageExtractorProperties();

    public ConcreteOctaveLocalFeatureCollector(FE featureExtractor) {
        super(featureExtractor);
    }

    @Override
    public void foundInterestPoint(OctaveInterestPointFinder<OCTAVE, IMAGE> finder, float x, float y, float octaveScale) {
        int currentScaleIndex = finder.getCurrentScaleIndex();
        this.extractionProperties.image = ((Octave)finder.getOctave()).images[currentScaleIndex];
        this.extractionProperties.scale = octaveScale;
        this.extractionProperties.x = x;
        this.extractionProperties.y = y;
        float octSize = ((Octave)finder.getOctave()).octaveSize;
        this.addFeature(octSize * x, octSize * y, octSize * octaveScale);
    }

    protected void addFeature(float imx, float imy, float imscale) {
        FeatureVector[] fvs = this.featureExtractor.extractFeature(this.extractionProperties);
        ScaleSpaceLocation loc = new ScaleSpaceLocation(imx, imy, imscale);
        for (FeatureVector fv : fvs) {
            this.features.add((Object)new LocalFeatureImpl((Location)loc, fv));
        }
    }
}

