/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.collector;

import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.feature.local.detector.dog.collector.AbstractOctaveLocalFeatureCollector;
import org.openimaj.image.feature.local.detector.dog.extractor.ScaleSpaceFeatureExtractor;
import org.openimaj.image.feature.local.detector.pyramid.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.extraction.ScaleSpaceImageExtractorProperties;
import org.openimaj.image.feature.local.keypoints.Keypoint;

public class OctaveKeypointCollector<IMAGE extends Image<?, IMAGE>>
extends AbstractOctaveLocalFeatureCollector<GaussianOctave<IMAGE>, ScaleSpaceFeatureExtractor<OrientedFeatureVector, IMAGE>, Keypoint, IMAGE> {
    protected ScaleSpaceImageExtractorProperties<IMAGE> extractionProperties = new ScaleSpaceImageExtractorProperties();

    public OctaveKeypointCollector(ScaleSpaceFeatureExtractor<OrientedFeatureVector, IMAGE> featureExtractor) {
        super(featureExtractor);
    }

    @Override
    public void foundInterestPoint(OctaveInterestPointFinder<GaussianOctave<IMAGE>, IMAGE> finder, float x, float y, float octaveScale) {
        int currentScaleIndex = finder.getCurrentScaleIndex();
        this.extractionProperties.image = finder.getOctave().images[currentScaleIndex];
        this.extractionProperties.scale = octaveScale;
        this.extractionProperties.x = x;
        this.extractionProperties.y = y;
        float octSize = finder.getOctave().octaveSize;
        this.addFeature(octSize * x, octSize * y, octSize * octaveScale);
    }

    protected void addFeature(float imx, float imy, float imscale) {
        OrientedFeatureVector[] fvs;
        for (OrientedFeatureVector fv : fvs = (OrientedFeatureVector[])((ScaleSpaceFeatureExtractor)this.featureExtractor).extractFeature(this.extractionProperties)) {
            this.features.add((Object)new Keypoint(imx, imy, fv.orientation, imscale, (byte[])fv.values));
        }
    }
}

