/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.extractor;

import gnu.trove.list.array.TFloatArrayList;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.detector.dog.extractor.AbstractDominantOrientationExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.OrientationHistogramExtractor;
import org.openimaj.image.feature.local.extraction.GradientScaleSpaceImageExtractorProperties;

public class DominantOrientationExtractor
extends AbstractDominantOrientationExtractor {
    public static float DEFAULT_PEAK_THRESHOLD = 0.8f;
    protected OrientationHistogramExtractor oriHistExtractor;
    protected float peakThreshold;

    public DominantOrientationExtractor() {
        this(DEFAULT_PEAK_THRESHOLD, new OrientationHistogramExtractor());
    }

    public DominantOrientationExtractor(float peakThreshold, OrientationHistogramExtractor oriHistExtractor) {
        this.peakThreshold = peakThreshold;
        this.oriHistExtractor = oriHistExtractor;
    }

    @Override
    public float[] extractFeatureRaw(GradientScaleSpaceImageExtractorProperties<FImage> properties) {
        float[] hist = this.getOriHistExtractor().extractFeatureRaw(properties);
        float maxval = 0.0f;
        for (int i = 0; i < this.getOriHistExtractor().numBins; ++i) {
            if (!(hist[i] > maxval)) continue;
            maxval = hist[i];
        }
        float thresh = this.peakThreshold * maxval;
        TFloatArrayList dominantOrientations = new TFloatArrayList();
        for (int i = 0; i < this.getOriHistExtractor().numBins; ++i) {
            float prevVal = hist[i == 0 ? this.getOriHistExtractor().numBins - 1 : i - 1];
            float nextVal = hist[i == this.getOriHistExtractor().numBins - 1 ? 0 : i + 1];
            float thisVal = hist[i];
            if (!(thisVal >= thresh) || !(thisVal > prevVal) || !(thisVal > nextVal)) continue;
            float peakDelta = this.fitPeak(prevVal, thisVal, nextVal);
            float angle = (float)Math.PI * 2 * ((float)i + 0.5f + peakDelta) / (float)this.getOriHistExtractor().numBins - (float)Math.PI;
            dominantOrientations.add(angle);
        }
        return dominantOrientations.toArray();
    }

    float fitPeak(float a, float b, float c) {
        return 0.5f * (a - c) / (a - 2.0f * b + c);
    }

    public OrientationHistogramExtractor getOriHistExtractor() {
        return this.oriHistExtractor;
    }
}

