/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.extractor;

import org.openimaj.feature.FloatFV;
import org.openimaj.image.FImage;
import org.openimaj.image.feature.local.extraction.FeatureVectorExtractor;
import org.openimaj.image.feature.local.extraction.GradientScaleSpaceImageExtractorProperties;

public class OrientationHistogramExtractor
implements FeatureVectorExtractor<FloatFV, GradientScaleSpaceImageExtractorProperties<FImage>> {
    public static int DEFAULT_NUM_BINS = 36;
    public static float DEFAULT_SCALING = 1.5f;
    public static int DEFAULT_SMOOTHING_ITERATIONS = 6;
    public static float DEFAULT_SAMPLING_SIZE = 3.0f;
    protected int numBins;
    protected float scaling;
    protected int smoothingIterations;
    protected float samplingSize;

    public OrientationHistogramExtractor() {
        this(DEFAULT_NUM_BINS, DEFAULT_SCALING, DEFAULT_SMOOTHING_ITERATIONS, DEFAULT_SAMPLING_SIZE);
    }

    public OrientationHistogramExtractor(int numBins, float scaling, int smoothingIterations, float samplingSize) {
        this.numBins = numBins;
        this.scaling = scaling;
        this.smoothingIterations = smoothingIterations;
        this.samplingSize = samplingSize;
    }

    public FloatFV[] extractFeature(GradientScaleSpaceImageExtractorProperties<FImage> props) {
        return new FloatFV[]{new FloatFV(this.extractFeatureRaw(props))};
    }

    public float[] extractFeatureRaw(GradientScaleSpaceImageExtractorProperties<FImage> properties) {
        return this.createHistogram(properties.x, properties.y, properties.scale, properties.magnitude, properties.orientation);
    }

    float[] createHistogram(float fx, float fy, float scale, FImage magnitude, FImage orientation) {
        float[] hist = new float[this.numBins];
        int ix = Math.round(fx);
        int iy = Math.round(fy);
        float sigma = this.scaling * scale;
        int radius = (int)(sigma * this.samplingSize);
        int startx = Math.max(ix - radius, 1);
        int stopx = Math.min(ix + radius, magnitude.width - 2);
        int starty = Math.max(iy - radius, 1);
        int stopy = Math.min(iy + radius, magnitude.height - 2);
        float radiusSq = ((float)radius + 0.5f) * ((float)radius + 0.5f);
        double sigmaSq2 = 2.0 * (double)sigma * (double)sigma;
        for (int y = starty; y <= stopy; ++y) {
            for (int x = startx; x <= stopx; ++x) {
                int bin;
                float distsq = ((float)y - fy) * ((float)y - fy) + ((float)x - fx) * ((float)x - fx);
                if (!(distsq <= radiusSq)) continue;
                float weight = (float)Math.exp((double)(-distsq) / sigmaSq2);
                float angle = orientation.pixels[y][x];
                int n = bin = (int)((double)this.numBins * ((double)angle + Math.PI) / 6.283195307179586);
                hist[n] = hist[n] + weight * magnitude.pixels[y][x];
            }
        }
        for (int i = 0; i < this.smoothingIterations; ++i) {
            this.circularSmooth(hist);
        }
        return hist;
    }

    protected void circularSmooth(float[] buffer) {
        float prev = buffer[buffer.length - 1];
        for (int i = 0; i < buffer.length; ++i) {
            float temp = buffer[i];
            buffer[i] = (prev + buffer[i] + buffer[i + 1 == buffer.length ? 0 : i + 1]) / 3.0f;
            prev = temp;
        }
    }
}

