/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.detector.dog.pyramid;

import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analysis.pyramid.Octave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramidOptions;
import org.openimaj.image.feature.local.detector.dog.pyramid.FirstBandDoGOctave;
import org.openimaj.image.feature.local.detector.pyramid.OctaveInterestPointFinder;
import org.openimaj.image.feature.local.detector.pyramid.OctaveInterestPointListener;

public class FirstBandDoGOctaveExtremaFinder
implements OctaveInterestPointFinder<GaussianOctave<MBFImage>, MBFImage>,
OctaveInterestPointListener<GaussianOctave<FImage>, FImage> {
    GaussianOctave<MBFImage> gaussianOctave;
    FirstBandDoGOctave dogOctave;
    OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> innerFinder;
    OctaveInterestPointListener<GaussianOctave<MBFImage>, MBFImage> listener;

    public FirstBandDoGOctaveExtremaFinder(OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> finder) {
        this.innerFinder = finder;
        finder.setOctaveInterestPointListener(this);
    }

    public FirstBandDoGOctaveExtremaFinder(OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> finder, OctaveInterestPointListener<GaussianOctave<MBFImage>, MBFImage> listener) {
        this(finder);
        this.listener = listener;
    }

    @Override
    public void setOctaveInterestPointListener(OctaveInterestPointListener<GaussianOctave<MBFImage>, MBFImage> listener) {
        this.listener = listener;
    }

    @Override
    public OctaveInterestPointListener<GaussianOctave<MBFImage>, MBFImage> getOctaveInterestPointListener() {
        return this.listener;
    }

    public void process(GaussianOctave<MBFImage> octave) {
        this.gaussianOctave = octave;
        GaussianPyramidOptions opts = new GaussianPyramidOptions((GaussianPyramidOptions)octave.options);
        GaussianPyramid gp = new GaussianPyramid(opts);
        this.dogOctave = new FirstBandDoGOctave((GaussianPyramid<FImage>)gp, octave.octaveSize);
        this.dogOctave.process(octave);
        this.innerFinder.process((Octave)this.dogOctave);
    }

    @Override
    public GaussianOctave<MBFImage> getOctave() {
        return this.gaussianOctave;
    }

    public GaussianOctave<FImage> getDoGOctave() {
        return this.dogOctave;
    }

    @Override
    public int getCurrentScaleIndex() {
        return this.innerFinder.getCurrentScaleIndex();
    }

    @Override
    public void foundInterestPoint(OctaveInterestPointFinder<GaussianOctave<FImage>, FImage> finder, float x, float y, float octaveScale) {
        if (this.listener != null) {
            this.listener.foundInterestPoint(this, x, y, octaveScale);
        }
    }
}

