/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.citation.annotation.References;
import org.openimaj.feature.local.list.LocalFeatureList;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianPyramid;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.feature.local.descriptor.gradient.SIFTFeatureProvider;
import org.openimaj.image.feature.local.detector.dog.collector.OctaveKeypointCollector;
import org.openimaj.image.feature.local.detector.dog.extractor.ColourGradientFeatureExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.DominantOrientationExtractor;
import org.openimaj.image.feature.local.detector.dog.extractor.OrientationHistogramExtractor;
import org.openimaj.image.feature.local.detector.dog.pyramid.FirstBandDoGOctaveExtremaFinder;
import org.openimaj.image.feature.local.detector.pyramid.BasicOctaveExtremaFinder;
import org.openimaj.image.feature.local.engine.DoGSIFTEngineOptions;
import org.openimaj.image.feature.local.engine.Engine;
import org.openimaj.image.feature.local.keypoints.Keypoint;

@References(references={@Reference(type=ReferenceType.Article, author={"Burghouts, Gertjan J.", "Geusebroek, Jan-Mark"}, title="Performance evaluation of local colour invariants", year="2009", journal="Comput. Vis. Image Underst.", pages={"48", "", "62"}, url="http://dx.doi.org/10.1016/j.cviu.2008.07.003", month="jan", number="1", publisher="Elsevier Science Inc.", volume="113", customData={"issn", "1077-3142", "numpages", "15", "doi", "10.1016/j.cviu.2008.07.003", "acmid", "1465842", "address", "New York, NY, USA", "keywords", "Colour, Local descriptors, SIFT"}), @Reference(type=ReferenceType.Article, author={"van de Sande, K. E. A.", "Gevers, T.", "Snoek, C. G. M."}, title="Evaluating Color Descriptors for Object and Scene Recognition", year="2010", journal="IEEE Transactions on Pattern Analysis and Machine Intelligence", pages={"1582", "", "1596"}, url="http://www.science.uva.nl/research/publications/2010/vandeSandeTPAMI2010", number="9", volume="32")})
public class DoGColourSIFTEngine
implements Engine<Keypoint, MBFImage> {
    DoGSIFTEngineOptions<MBFImage> options;

    public DoGColourSIFTEngine() {
        this(new DoGSIFTEngineOptions<MBFImage>());
    }

    public DoGColourSIFTEngine(DoGSIFTEngineOptions<MBFImage> options) {
        this.options = options;
    }

    @Override
    public LocalFeatureList<Keypoint> findFeatures(MBFImage image) {
        FImage luminance = (FImage)ColourSpace.convert((MBFImage)image, (ColourSpace)ColourSpace.LUMINANCE_NTSC).bands.get(0);
        return this.findFeatures(image, luminance);
    }

    public LocalFeatureList<Keypoint> findFeatures(MBFImage image, FImage luminance) {
        MBFImage newimage = new MBFImage(ColourSpace.CUSTOM, new FImage[0]);
        newimage.bands.add(luminance);
        newimage.bands.addAll(image.bands);
        return this.findFeaturesInternal(newimage);
    }

    protected LocalFeatureList<Keypoint> findFeaturesInternal(MBFImage image) {
        FirstBandDoGOctaveExtremaFinder finder = new FirstBandDoGOctaveExtremaFinder(new BasicOctaveExtremaFinder(this.options.magnitudeThreshold, this.options.eigenvalueRatio));
        OctaveKeypointCollector<MBFImage> collector = new OctaveKeypointCollector<MBFImage>(new ColourGradientFeatureExtractor(new DominantOrientationExtractor(this.options.peakThreshold, new OrientationHistogramExtractor(this.options.numOriHistBins, this.options.scaling, this.options.smoothingIterations, this.options.samplingSize)), new SIFTFeatureProvider(this.options.numOriBins, this.options.numSpatialBins, this.options.valueThreshold, this.options.gaussianSigma), this.options.magnificationFactor * (float)this.options.numSpatialBins));
        finder.setOctaveInterestPointListener(collector);
        this.options.setOctaveProcessor(finder);
        GaussianPyramid pyr = new GaussianPyramid(this.options);
        pyr.process((Image)image);
        return collector.getFeatures();
    }

    public DoGSIFTEngineOptions<MBFImage> getOptions() {
        return this.options;
    }
}

