/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.engine.ipd;

import Jama.Matrix;
import org.openimaj.image.Image;
import org.openimaj.image.combiner.AccumulatingImageCombiner;
import org.openimaj.image.feature.local.extraction.ScaleSpaceImageExtractorProperties;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.processing.transform.ProjectionProcessor;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class InterestPointImageExtractorProperties<P, I extends Image<P, I>>
extends ScaleSpaceImageExtractorProperties<I> {
    private boolean affineInvariant;
    public int halfWindowSize;
    public int featureWindowSize;
    public InterestPointData interestPointData;

    public InterestPointImageExtractorProperties(I image, InterestPointData point) {
        this(image, point, true);
    }

    public InterestPointImageExtractorProperties(I image, InterestPointData point, boolean affineInvariant) {
        this.affineInvariant = affineInvariant;
        this.image = this.extractSubImage(image, point);
        if (this.image == null) {
            System.out.println();
        }
        this.scale = point.getScale();
        this.x = this.image.getWidth() / 2;
        this.y = this.image.getHeight() / 2;
        this.interestPointData = point;
    }

    private I extractSubImage(I image, InterestPointData point) {
        double scaleFctor = Math.max(9, Math.round(3.0f * point.scale));
        this.halfWindowSize = (int)scaleFctor;
        this.featureWindowSize = this.halfWindowSize * 2;
        I subImage = null;
        Matrix transformMatrix = null;
        transformMatrix = this.affineInvariant ? this.calculateTransformMatrix(point) : TransformUtilities.translateMatrix((double)(-point.x), (double)(-point.y));
        subImage = this.extractSubImage(image, transformMatrix, this.halfWindowSize, this.featureWindowSize);
        return subImage;
    }

    private I extractSubImage(I image, Matrix transformMatrix, int windowSize, int featureWindowSize) {
        ProjectionProcessor pp = new ProjectionProcessor();
        pp.setMatrix(transformMatrix);
        image.accumulateWith((AccumulatingImageCombiner)pp);
        Image patch = pp.performProjection(-windowSize, windowSize, -windowSize, windowSize, null);
        if (patch.getWidth() > 0 && patch.getHeight() > 0) {
            Image patchToReturn = patch.extractCenter(featureWindowSize, featureWindowSize);
            return (I)patchToReturn;
        }
        return null;
    }

    private Matrix calculateTransformMatrix(InterestPointData point) {
        Matrix transform = point.getTransform();
        this.halfWindowSize = this.halfWindowSize;
        this.featureWindowSize = this.halfWindowSize * 2;
        Matrix center = TransformUtilities.translateMatrix((double)(-point.x), (double)(-point.y));
        transform = transform.times(center);
        return transform;
    }
}

