/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.keypoints;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.OrientedFeatureVector;
import org.openimaj.image.feature.local.interest.InterestPointData;
import org.openimaj.image.feature.local.keypoints.Keypoint;

public abstract class InterestPointKeypoint<T extends InterestPointData>
extends Keypoint {
    private static final long serialVersionUID = 1L;
    public T location;

    public InterestPointKeypoint() {
    }

    public InterestPointKeypoint(int length) {
        super(length);
    }

    public InterestPointKeypoint(OrientedFeatureVector featureVector, T point) {
        this.ivec = (byte[])((byte[])featureVector.values).clone();
        this.location = point;
        this.x = ((InterestPointData)((Object)this.location)).x;
        this.y = ((InterestPointData)((Object)this.location)).y;
        this.scale = ((InterestPointData)((Object)this.location)).scale;
        this.ori = featureVector.orientation;
    }

    public abstract T createEmptyLocation();

    @Override
    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        this.location = this.createEmptyLocation();
        ((InterestPointData)((Object)this.location)).readBinary(in);
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        super.readASCII(in);
        this.location = this.createEmptyLocation();
        ((InterestPointData)((Object)this.location)).readASCII(in);
    }

    @Override
    public byte[] binaryHeader() {
        return super.binaryHeader();
    }

    @Override
    public String asciiHeader() {
        return super.asciiHeader();
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        super.writeBinary(out);
        ((InterestPointData)((Object)this.location)).writeBinary(out);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        super.writeASCII(out);
        ((InterestPointData)((Object)this.location)).writeASCII(out);
    }
}

