/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.feature.local.keypoints;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.feature.local.ScaleSpaceLocation;

public class KeypointLocation
extends ScaleSpaceLocation {
    private static final long serialVersionUID = 1L;
    public float orientation;

    public KeypointLocation() {
    }

    public KeypointLocation(float x, float y, float orientation, float scale) {
        super(x, y, scale);
        this.orientation = orientation;
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.scale);
        out.writeFloat(this.orientation);
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.format("%4.2f %4.2f %4.2f %4.3f", Float.valueOf(this.y), Float.valueOf(this.x), Float.valueOf(this.scale), Float.valueOf(this.orientation));
        out.println();
    }

    public void readBinary(DataInput in) throws IOException {
        super.readBinary(in);
        this.orientation = in.readFloat();
    }

    public void readASCII(Scanner in) throws IOException {
        super.readASCII(in);
        this.orientation = Float.parseFloat(in.next());
    }

    public byte[] binaryHeader() {
        return "".getBytes();
    }

    public String asciiHeader() {
        return "";
    }

    public Float getOrdinate(int dimension) {
        float[] pos = new float[]{this.x, this.y, this.scale, this.orientation};
        return Float.valueOf(pos[dimension]);
    }

    public int getDimensions() {
        return 3;
    }
}

