/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class Pyramid {
    int subsampling;
    int nLevels;
    FImage[] img;
    int[] ncols;
    int[] nrows;

    public Pyramid(int ncols, int nrows, int subsampling, int nlevels) {
        if (subsampling != 2 && subsampling != 4 && subsampling != 8 && subsampling != 16 && subsampling != 32) {
            throw new RuntimeException("(_KLTCreatePyramid)  Pyramid's subsampling must be either 2, 4, 8, 16, or 32");
        }
        this.img = new FImage[nlevels];
        this.ncols = new int[nlevels];
        this.nrows = new int[nlevels];
        this.subsampling = subsampling;
        this.nLevels = nlevels;
        for (int i = 0; i < nlevels; ++i) {
            this.img[i] = new FImage(ncols, nrows);
            this.ncols[i] = ncols;
            this.nrows[i] = nrows;
            ncols /= subsampling;
            nrows /= subsampling;
        }
    }

    void computePyramid(FImage img, float sigma_fact) {
        int ncols = img.width;
        int nrows = img.height;
        int subsampling = this.subsampling;
        int subhalf = subsampling / 2;
        float sigma = (float)subsampling * sigma_fact;
        if (subsampling != 2 && subsampling != 4 && subsampling != 8 && subsampling != 16 && subsampling != 32) {
            throw new RuntimeException("(_KLTComputePyramid)  Pyramid's subsampling must be either 2, 4, 8, 16, or 32");
        }
        this.img[0] = img.clone();
        FImage currimg = img;
        for (int i = 1; i < this.nLevels; ++i) {
            FImage tmpimg = (FImage)currimg.process((SinglebandImageProcessor)new FGaussianConvolve(sigma));
            ncols /= subsampling;
            nrows /= subsampling;
            for (int y = 0; y < nrows; ++y) {
                for (int x = 0; x < ncols; ++x) {
                    this.img[i].pixels[y][x] = tmpimg.pixels[subsampling * y + subhalf][subsampling * x + subhalf];
                }
            }
            currimg = this.img[i];
        }
    }
}

