/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.tracking.klt.examples;

import java.io.IOException;
import java.io.InputStream;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.video.tracking.klt.FeatureList;
import org.openimaj.video.tracking.klt.KLTTracker;
import org.openimaj.video.tracking.klt.TrackingContext;

public class Example1 {
    public static void main(String[] args) throws IOException {
        int i;
        int nFeatures = 100;
        TrackingContext tc = new TrackingContext();
        FeatureList fl = new FeatureList(nFeatures);
        KLTTracker tracker = new KLTTracker(tc, fl);
        System.out.println(tc);
        FImage img1 = ImageUtilities.readF((InputStream)Example1.class.getResourceAsStream("img0.pgm"));
        FImage img2 = ImageUtilities.readF((InputStream)Example1.class.getResourceAsStream("img1.pgm"));
        tracker.selectGoodFeatures(img1);
        System.out.println("\nIn first image:\n");
        for (i = 0; i < fl.features.length; ++i) {
            System.out.format("Feature #%d:  (%f,%f) with value of %d\n", i, Float.valueOf(fl.features[i].x), Float.valueOf(fl.features[i].y), fl.features[i].val);
        }
        DisplayUtilities.display((Image)fl.drawFeatures(img1));
        fl.writeFeatureList(null, "%3d");
        tracker.trackFeatures(img1, img2);
        System.out.println("\nIn second image:\n");
        for (i = 0; i < fl.features.length; ++i) {
            System.out.format("Feature #%d:  (%f,%f) with value of %d\n", i, Float.valueOf(fl.features[i].x), Float.valueOf(fl.features[i].y), fl.features[i].val);
        }
        DisplayUtilities.display((Image)fl.drawFeatures(img2));
        fl.writeFeatureList(null, "%5.1f");
    }
}

