/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.data;

import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseRowMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseVector;
import java.util.Random;
import org.openimaj.ml.linear.data.MatrixDataGenerator;
import org.openimaj.util.pair.Pair;

public class BiconvexDataGenerator
implements MatrixDataGenerator<Matrix> {
    private int seed;
    private int nusers;
    private int nfeatures;
    private int ntasks;
    private boolean indw;
    private boolean indu;
    private Random rng;
    private SparseMatrixFactoryMTJ smf;
    private Matrix u;
    private SparseMatrix w;
    private double noise;
    private double xsparcity;

    public BiconvexDataGenerator() {
        this(5, 10, 1, 0.3, 0.0, true, false, -1, 1.0E-4);
    }

    public BiconvexDataGenerator(int nusers, int nfeatures, int ntasks, double sparcity, double xsparcity, boolean indw, boolean indu, int seed, double noise) {
        int i;
        this.seed = seed;
        this.nusers = nusers;
        this.nfeatures = nfeatures;
        this.ntasks = ntasks;
        this.indw = indw;
        this.indu = indu;
        this.noise = Math.abs(noise);
        this.xsparcity = xsparcity;
        this.smf = new SparseMatrixFactoryMTJ();
        this.rng = this.seed >= 0 ? new Random(this.seed) : new Random();
        this.u = indu ? this.smf.createUniformRandom(nusers, ntasks, 0.0, 1.0, this.rng) : this.smf.createUniformRandom(nusers, 1, 0.0, 1.0, this.rng);
        this.w = indw ? (SparseMatrix)this.smf.createUniformRandom(nfeatures, ntasks, 0.0, 1.0, this.rng) : (SparseMatrix)this.smf.createUniformRandom(nfeatures, 1, 0.0, 1.0, this.rng);
        SparseVector zeroUserWord = this.smf.createMatrix(1, ntasks).getRow(0);
        for (i = 0; i < nusers; ++i) {
            if (!(this.rng.nextDouble() < sparcity)) continue;
            this.u.setRow(i, (Vector)zeroUserWord);
        }
        for (i = 0; i < nfeatures; ++i) {
            if (!(this.rng.nextDouble() < sparcity)) continue;
            this.w.setRow(i, (Vector)zeroUserWord);
        }
    }

    private Matrix calcY(Matrix u, Matrix x, Matrix w) {
        Matrix ut = u.transpose();
        Matrix xt = x.transpose();
        Matrix utdotxt = ut.times(xt);
        return utdotxt.times(w);
    }

    @Override
    public Pair<Matrix> generate() {
        Matrix x = this.smf.createUniformRandom(this.nfeatures, this.nusers, 0.0, 1.0, this.rng);
        SparseMatrix xSparse = this.smf.createMatrix(this.nfeatures, this.nusers);
        for (MatrixEntry matrixEntry : x) {
            if (!(this.rng.nextDouble() >= this.xsparcity)) continue;
            xSparse.setElement(matrixEntry.getRowIndex(), matrixEntry.getColumnIndex(), matrixEntry.getValue());
        }
        x = xSparse;
        Matrix y = null;
        if (this.indw && this.indu) {
            y = this.smf.createMatrix(1, this.ntasks);
            for (int i = 0; i < this.ntasks; ++i) {
                Matrix subu = this.u.getSubMatrix(0, this.nusers - 1, i, i);
                SparseRowMatrix subw = this.w.getSubMatrix(0, this.nfeatures - 1, i, i);
                Matrix yval = this.calcY(subu, x, (Matrix)subw);
                y.setSubMatrix(0, i, yval);
            }
        } else {
            y = this.calcY(this.u, x, (Matrix)this.w);
        }
        if (y.getNumColumns() < y.getNumRows()) {
            y = y.transpose();
        }
        if (this.noise != 0.0) {
            SparseMatrix nm = (SparseMatrix)this.smf.createUniformRandom(1, this.ntasks, -this.noise, this.noise, this.rng);
            y.plusEquals((Ring)nm);
        }
        return new Pair((Object)x, (Object)y);
    }

    public Matrix getU() {
        return this.u;
    }

    public Matrix getW() {
        return this.w;
    }
}

