/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.linear.kernel;

import java.util.List;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import org.openimaj.math.matrix.GramSchmidtProcess;
import org.openimaj.ml.linear.kernel.VectorKernel;
import org.openimaj.util.pair.IndependentPair;

public class LinearVectorKernel
implements VectorKernel {
    public Double apply(IndependentPair<double[], double[]> in) {
        double[] first = (double[])in.firstObject();
        double[] second = (double[])in.secondObject();
        return new DenseVector(first, false).dot((Vector)new DenseVector(second, false));
    }

    public static double[] getPlanePoint(List<double[]> supports, List<Double> weights, double bias, double ... setValues) {
        if (supports.size() == 0) {
            throw new RuntimeException("Can't estimate plane point without supports");
        }
        double[] w = LinearVectorKernel.getDirection(supports, weights);
        double[] x = new double[w.length];
        double resid = 0.0;
        int index = 0;
        for (int i = 0; i < w.length; ++i) {
            if (Double.isNaN(setValues[i])) {
                index = i;
                continue;
            }
            resid += setValues[i] * w[i];
            x[i] = setValues[i];
        }
        if (w[index] == 0.0) {
            return new double[w.length];
        }
        x[index] = (bias + resid) / -w[index];
        return x;
    }

    public static Vector[] getPlaneDirections(List<double[]> supports, List<Double> weights) {
        double[] dir = LinearVectorKernel.getDirection(supports, weights);
        boolean ind = false;
        Vector[] all = GramSchmidtProcess.perform((double[])dir);
        Vector[] ret = new Vector[all.length - 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = all[i + 1];
        }
        return ret;
    }

    public static double[] getDirection(List<double[]> supports, List<Double> weights) {
        DenseVector ret = null;
        for (int i = 0; i < supports.size(); ++i) {
            double[] sup = supports.get(i);
            double weight = weights.get(i);
            DenseVector scale = new DenseVector(sup).scale(weight);
            if (ret == null) {
                ret = scale;
                continue;
            }
            ret.add((Vector)scale);
        }
        double[] retdata = new DenseVector(ret).getData();
        return retdata;
    }
}

