/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.pca;

import Jama.Matrix;
import java.util.Collection;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureVector;
import org.openimaj.math.matrix.algorithm.pca.PrincipalComponentAnalysis;
import org.openimaj.math.matrix.algorithm.pca.SvdPrincipalComponentAnalysis;

public class FeatureVectorPCA
extends PrincipalComponentAnalysis {
    PrincipalComponentAnalysis inner;

    public FeatureVectorPCA() {
        this.inner = new SvdPrincipalComponentAnalysis();
    }

    public FeatureVectorPCA(PrincipalComponentAnalysis inner) {
        this.inner = inner;
    }

    public void learnBasis(FeatureVector[] data) {
        double[][] d = new double[data.length][];
        for (int i = 0; i < data.length; ++i) {
            d[i] = data[i].asDoubleVector();
        }
        this.learnBasis(d);
    }

    public void learnBasis(Collection<? extends FeatureVector> data) {
        double[][] d = new double[data.size()][];
        int i = 0;
        for (FeatureVector featureVector : data) {
            d[i++] = featureVector.asDoubleVector();
        }
        this.learnBasis(d);
    }

    public DoubleFV project(FeatureVector vector) {
        return new DoubleFV(this.project(vector.asDoubleVector()));
    }

    public void learnBasis(double[][] data) {
        this.inner.learnBasis(data);
        this.basis = this.inner.getBasis();
        this.eigenvalues = this.inner.getEigenValues();
        this.mean = this.inner.getMean();
    }

    protected void learnBasisNorm(Matrix norm) {
        this.inner.learnBasis(norm);
    }

    public DoubleFV generate(DoubleFV scalings) {
        return new DoubleFV(this.generate((double[])scalings.values));
    }
}

