/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.processor;

import Jama.Matrix;
import org.openimaj.ml.regression.LinearRegression;
import org.openimaj.ml.timeseries.processor.TimeSeriesProcessor;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;
import org.openimaj.util.array.ArrayUtils;

public class LinearRegressionProcessor
implements TimeSeriesProcessor<double[], Double, DoubleTimeSeries> {
    private LinearRegression reg;
    private boolean regdefined;

    public LinearRegressionProcessor() {
        this.regdefined = false;
    }

    public LinearRegressionProcessor(LinearRegression reg) {
        this.reg = reg;
        this.regdefined = true;
    }

    @Override
    public void process(DoubleTimeSeries series) {
        Matrix x = new Matrix((double[][])new double[][]{ArrayUtils.convertToDouble((long[])series.getTimes())}).transpose();
        if (!this.regdefined) {
            this.reg = new LinearRegression();
            Matrix y = new Matrix((double[][])new double[][]{series.getData()}).transpose();
            this.reg.estimate(y, x);
        }
        Matrix predicted = this.reg.predict(x);
        series.set(series.getTimes(), predicted.transpose().getArray()[0]);
    }

    public void holdreg(boolean regdefined) {
        this.regdefined = regdefined;
    }

    public LinearRegression getRegression() {
        return this.reg;
    }
}

