/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation.utils;

import de.bwaldvogel.liblinear.Feature;
import de.bwaldvogel.liblinear.FeatureNode;
import org.openimaj.feature.FeatureVector;
import org.openimaj.feature.SparseByteFV;
import org.openimaj.feature.SparseDoubleFV;
import org.openimaj.feature.SparseFloatFV;
import org.openimaj.feature.SparseIntFV;
import org.openimaj.feature.SparseLongFV;
import org.openimaj.feature.SparseShortFV;
import org.openimaj.util.array.SparseByteArray;
import org.openimaj.util.array.SparseDoubleArray;
import org.openimaj.util.array.SparseFloatArray;
import org.openimaj.util.array.SparseIntArray;
import org.openimaj.util.array.SparseLongArray;
import org.openimaj.util.array.SparseShortArray;

public class LiblinearHelper {
    public static Feature[] convert(FeatureVector feature, double bias) {
        Feature[] out;
        int extra = bias <= 0.0 ? 0 : 1;
        int i = 0;
        if (feature instanceof SparseDoubleFV) {
            out = new Feature[((SparseDoubleFV)feature).values.used() + extra];
            for (SparseDoubleArray.Entry entry : ((SparseDoubleFV)feature).getVector().entries()) {
                out[i++] = new FeatureNode(entry.index + 1, entry.value);
            }
        } else if (feature instanceof SparseFloatFV) {
            out = new Feature[((SparseFloatFV)feature).values.used() + extra];
            for (SparseFloatArray.Entry entry : ((SparseFloatFV)feature).getVector().entries()) {
                out[i++] = new FeatureNode(entry.index + 1, (double)entry.value);
            }
        } else if (feature instanceof SparseByteFV) {
            out = new Feature[((SparseByteFV)feature).values.used() + extra];
            for (SparseByteArray.Entry entry : ((SparseByteFV)feature).getVector().entries()) {
                out[i++] = new FeatureNode(entry.index + 1, (double)entry.value);
            }
        } else if (feature instanceof SparseShortFV) {
            out = new Feature[((SparseShortFV)feature).values.used() + extra];
            for (SparseShortArray.Entry entry : ((SparseShortFV)feature).getVector().entries()) {
                out[i++] = new FeatureNode(entry.index + 1, (double)entry.value);
            }
        } else if (feature instanceof SparseIntFV) {
            out = new Feature[((SparseIntFV)feature).values.used() + extra];
            for (SparseIntArray.Entry entry : ((SparseIntFV)feature).getVector().entries()) {
                out[i++] = new FeatureNode(entry.index + 1, (double)entry.value);
            }
        } else if (feature instanceof SparseLongFV) {
            out = new Feature[((SparseLongFV)feature).values.used() + extra];
            for (SparseLongArray.Entry entry : ((SparseLongFV)feature).getVector().entries()) {
                out[i++] = new FeatureNode(entry.index + 1, (double)entry.value);
            }
        } else {
            double[] array = feature.asDoubleVector();
            int numZero = 0;
            for (i = 0; i < array.length; ++i) {
                if (array[i] != 0.0) continue;
                ++numZero;
            }
            out = new Feature[array.length - numZero + extra];
            int j = 0;
            for (i = 0; i < array.length; ++i) {
                if (array[i] == 0.0) continue;
                out[j++] = new FeatureNode(i + 1, array[i]);
            }
        }
        if (extra == 1) {
            out[out.length - 1] = new FeatureNode(feature.length() + 1, bias);
        }
        return out;
    }

    public static double[] convertDense(FeatureVector feature, double bias) {
        double[] arr = feature.asDoubleVector();
        if (bias <= 0.0) {
            return arr;
        }
        double[] arr2 = new double[arr.length + 1];
        System.arraycopy(arr, 0, arr2, 0, arr.length);
        arr2[arr.length] = bias;
        return arr2;
    }
}

