/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.aggregator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openimaj.ml.regression.LinearRegression;
import org.openimaj.ml.timeseries.aggregator.SynchronisedTimeSeriesCollectionAggregator;
import org.openimaj.ml.timeseries.series.DoubleSynchronisedTimeSeriesCollection;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;
import org.openimaj.util.pair.IndependentPair;

public class WindowedLinearRegressionAggregator
implements SynchronisedTimeSeriesCollectionAggregator<DoubleTimeSeries, DoubleSynchronisedTimeSeriesCollection, DoubleTimeSeries> {
    private static final int DEFAULT_WINDOW_SIZE = 3;
    private static final int DEFAULT_OFFSET = 1;
    private LinearRegression reg;
    private boolean autoregressive = true;
    private List<IndependentPair<Integer, Integer>> windowOffsets = new ArrayList<IndependentPair<Integer, Integer>>();
    private String ydataName;

    private WindowedLinearRegressionAggregator() {
    }

    public WindowedLinearRegressionAggregator(String ydataName) {
        this();
        this.windowOffsets.add((IndependentPair<Integer, Integer>)IndependentPair.pair((Object)3, (Object)1));
        this.ydataName = ydataName;
    }

    public WindowedLinearRegressionAggregator(String ydataName, boolean autoregressive) {
        this();
        this.windowOffsets.add((IndependentPair<Integer, Integer>)IndependentPair.pair((Object)3, (Object)1));
        this.ydataName = ydataName;
        this.autoregressive = autoregressive;
    }

    public WindowedLinearRegressionAggregator(String ydataName, int windowsize) {
        this();
        this.ydataName = ydataName;
        this.windowOffsets.add((IndependentPair<Integer, Integer>)IndependentPair.pair((Object)windowsize, (Object)1));
    }

    public WindowedLinearRegressionAggregator(String ydataName, int windowsize, boolean autoregressive) {
        this();
        this.ydataName = ydataName;
        this.windowOffsets.add((IndependentPair<Integer, Integer>)IndependentPair.pair((Object)windowsize, (Object)1));
        this.autoregressive = autoregressive;
    }

    public WindowedLinearRegressionAggregator(String ydataName, int windowsize, int offset) {
        this();
        this.ydataName = ydataName;
        this.windowOffsets.add((IndependentPair<Integer, Integer>)IndependentPair.pair((Object)windowsize, (Object)offset));
    }

    public WindowedLinearRegressionAggregator(String ydataName, int windowsize, int offset, boolean autoregressive) {
        this();
        this.ydataName = ydataName;
        this.autoregressive = autoregressive;
        this.windowOffsets.add((IndependentPair<Integer, Integer>)IndependentPair.pair((Object)windowsize, (Object)offset));
    }

    public WindowedLinearRegressionAggregator(String ydataName, int windowsize, int offset, boolean autoregressive, DoubleSynchronisedTimeSeriesCollection other) {
        this();
        WindowedLinearRegressionAggregator regress = new WindowedLinearRegressionAggregator(ydataName, windowsize, offset, autoregressive);
        regress.aggregate(other);
        this.reg = regress.reg;
        this.ydataName = regress.ydataName;
        this.autoregressive = regress.autoregressive;
        this.windowOffsets = regress.windowOffsets;
    }

    @SafeVarargs
    public WindowedLinearRegressionAggregator(String ydataName, boolean autoregressive, IndependentPair<Integer, Integer> ... windowOffsets) {
        this();
        this.ydataName = ydataName;
        this.autoregressive = autoregressive;
        for (IndependentPair<Integer, Integer> independentPair : windowOffsets) {
            this.windowOffsets.add(independentPair);
        }
    }

    public LinearRegression getRegression() {
        return this.reg;
    }

    @Override
    public DoubleTimeSeries aggregate(DoubleSynchronisedTimeSeriesCollection series) {
        Set<String> names = series.getNames();
        if (!this.autoregressive) {
            names.remove(this.ydataName);
        }
        DoubleTimeSeries yseries = (DoubleTimeSeries)series.series(this.ydataName);
        double[] ydata = yseries.getData();
        series = (DoubleSynchronisedTimeSeriesCollection)series.collectionByNames(names);
        double[] data = series.flatten();
        if (this.windowOffsets.size() != series.nSeries() && this.windowOffsets.size() == 1) {
            IndependentPair<Integer, Integer> offset = this.windowOffsets.get(0);
            return this.aggregteSingle(yseries.getTimes(), ydata, data, (Integer)offset.firstObject(), (Integer)offset.secondObject(), series.nSeries());
        }
        return null;
    }

    private DoubleTimeSeries aggregteSingle(long[] times, double[] ydata, double[] data, int windowsize, int offset, int nseries) {
        ArrayList<IndependentPair> instances = new ArrayList<IndependentPair>();
        for (int i = windowsize + (offset - 1); i < ydata.length; ++i) {
            int start = (i - windowsize - (offset - 1)) * nseries;
            double[] datawindow = new double[windowsize * nseries];
            System.arraycopy(data, start, datawindow, 0, windowsize * nseries);
            instances.add(IndependentPair.pair((Object)datawindow, (Object)new double[]{ydata[i]}));
        }
        if (this.reg == null) {
            this.reg = new LinearRegression();
            this.reg.estimate(instances);
        }
        DoubleTimeSeries ret = new DoubleTimeSeries(times, new double[ydata.length]);
        Iterator instanceIter = instances.iterator();
        data = ret.getData();
        for (int i = windowsize + (offset - 1); i < ydata.length; ++i) {
            double[] predicted = this.reg.predict((double[])((IndependentPair)instanceIter.next()).firstObject());
            data[i] = predicted[0];
        }
        return ret.get(times[windowsize + (offset - 1)], times[ydata.length - 1]);
    }

    public LinearRegression getReg() {
        return this.reg;
    }
}

