/*
	AUTOMATICALLY GENERATED BY jTemp FROM
	/Users/jsh2/Work/openimaj/target/checkout/machine-learning/nearest-neighbour/src/main/jtemp/org/openimaj/knn/#T#NearestNeighboursExact.jtemp
*/
/**
 * Copyright (c) 2011, The University of Southampton and the individual contributors.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *   * 	Redistributions of source code must retain the above copyright notice,
 * 	this list of conditions and the following disclaimer.
 *
 *   *	Redistributions in binary form must reproduce the above copyright notice,
 * 	this list of conditions and the following disclaimer in the documentation
 * 	and/or other materials provided with the distribution.
 *
 *   *	Neither the name of the University of Southampton nor the names of its
 * 	contributors may be used to endorse or promote products derived from this
 * 	software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.openimaj.knn;

import java.util.ArrayList;
import java.util.List;

import org.openimaj.feature.ByteFVComparison;
import org.openimaj.feature.ByteFVComparator;
import org.openimaj.util.pair.IntFloatPair;
import org.openimaj.util.queue.BoundedPriorityQueue;

/**
 * Exact (brute-force) k-nearest-neighbour implementation.
 * 
 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
 * @author Sina Samangooei (ss@ecs.soton.ac.uk)
 */
public class ByteNearestNeighboursExact extends ByteNearestNeighbours {
    /**
	 * {@link NearestNeighboursFactory} for producing
	 * {@link ByteNearestNeighboursExact}s.
	 * 
	 * @author Jonathon Hare (jsh2@ecs.soton.ac.uk)
	 */
    public static final class Factory implements NearestNeighboursFactory<ByteNearestNeighboursExact, byte[]> {
        private final ByteFVComparator distance;
        
        /**
         * Construct the factory using Euclidean distance for the 
         * produced ByteNearestNeighbours instances.
         */
        public Factory() {
            this.distance = null;
        }
        
        /**
         * Construct the factory with the given distance function
         * for the produced ByteNearestNeighbours instances.
         * 
		 * @param distance
		 *            the distance function
         */
        public Factory(ByteFVComparator distance) {
            this.distance = distance;
        }
        
        @Override
        public ByteNearestNeighboursExact create(byte[][] data) {
            return new ByteNearestNeighboursExact(data, distance);
        }
    }
    
	protected final byte[][] pnts;
	protected final ByteFVComparator distance;

	/**
	 * Construct the ByteNearestNeighboursExact over the provided
	 * dataset and using Euclidean distance.
	 * @param pnts the dataset
	 */
	public ByteNearestNeighboursExact(final byte [][] pnts) {
		this(pnts, null);
	}

	/**
	 * Construct the ByteNearestNeighboursExact over the provided
	 * dataset with the given distance function. 
	 * <p>
	 * Note: If the distance function provides similarities rather
	 * than distances they are automatically inverted.
	 *  
	 * @param pnts the dataset
	 * @param distance the distance function
	 */
	public ByteNearestNeighboursExact(final byte [][] pnts, final ByteFVComparator distance) {
		this.pnts = pnts;
		this.distance = distance;
	}
	
	@Override
	public void searchNN(final byte [][] qus, int [] indices, float [] distances) {
		final int N = qus.length;
		
		final BoundedPriorityQueue<IntFloatPair> queue =
				new BoundedPriorityQueue<IntFloatPair>(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);

        //prepare working data
		List<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
		list.add(new IntFloatPair());
		list.add(new IntFloatPair());
		
		for (int n=0; n < N; ++n) {
			List<IntFloatPair> result = search(qus[n], queue, list);
			
			final IntFloatPair p = result.get(0);
			indices[n] = p.first;
			distances[n] = p.second;
		}
	}

	@Override
	public void searchKNN(final byte [][] qus, int K, int [][] indices, float [][] distances) {
		// Fix for when the user asks for too many points.
		K = Math.min(K, pnts.length);

		final int N = qus.length;

		final BoundedPriorityQueue<IntFloatPair> queue =
				new BoundedPriorityQueue<IntFloatPair>(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);

        //prepare working data
		List<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
		for (int i = 0; i < K + 1; i++) {
			list.add(new IntFloatPair());
		}

        // search on each query
		for (int n = 0; n < N; ++n) {
			List<IntFloatPair> result = search(qus[n], queue, list);
			
			for (int k = 0; k < K; ++k) {
				final IntFloatPair p = result.get(k);
				indices[n][k] = p.first;
				distances[n][k] = p.second;
			}
		}
	}
	
	@Override
	public void searchNN(final List<byte[]> qus, int [] indices, float [] distances) {
		final int N = qus.size();
		
		final BoundedPriorityQueue<IntFloatPair> queue =
				new BoundedPriorityQueue<IntFloatPair>(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);

        //prepare working data
		List<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
		list.add(new IntFloatPair());
		list.add(new IntFloatPair());
		
		for (int n=0; n < N; ++n) {
			List<IntFloatPair> result = search(qus.get(n), queue, list);
			
			final IntFloatPair p = result.get(0);
			indices[n] = p.first;
			distances[n] = p.second;
		}
	}

	@Override
	public void searchKNN(final List<byte[]> qus, int K, int [][] indices, float [][] distances) {
		// Fix for when the user asks for too many points.
		K = Math.min(K, pnts.length);

		final int N = qus.size();

		final BoundedPriorityQueue<IntFloatPair> queue =
				new BoundedPriorityQueue<IntFloatPair>(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);

        //prepare working data
		List<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
		for (int i = 0; i < K + 1; i++) {
			list.add(new IntFloatPair());
		}

        // search on each query
		for (int n = 0; n < N; ++n) {
			List<IntFloatPair> result = search(qus.get(n), queue, list);
			
			for (int k = 0; k < K; ++k) {
				final IntFloatPair p = result.get(k);
				indices[n][k] = p.first;
				distances[n][k] = p.second;
			}
		}
	}

    @Override
	public List<IntFloatPair> searchKNN(byte[] query, int K) {
		// Fix for when the user asks for too many points.
		K = Math.min(K, pnts.length);

		final BoundedPriorityQueue<IntFloatPair> queue =
				new BoundedPriorityQueue<IntFloatPair>(K, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);

        //prepare working data
		List<IntFloatPair> list = new ArrayList<IntFloatPair>(K + 1);
		for (int i = 0; i < K + 1; i++) {
			list.add(new IntFloatPair());
		}

        // search
        return search(query, queue, list);
	}

	@Override
	public IntFloatPair searchNN(final byte[] query) {
		final BoundedPriorityQueue<IntFloatPair> queue =
				new BoundedPriorityQueue<IntFloatPair>(1, IntFloatPair.SECOND_ITEM_ASCENDING_COMPARATOR);

        //prepare working data
		List<IntFloatPair> list = new ArrayList<IntFloatPair>(2);
		list.add(new IntFloatPair());
		list.add(new IntFloatPair());
		
		return search(query, queue, list).get(0);
	}

    private List<IntFloatPair> search(byte[] query, BoundedPriorityQueue<IntFloatPair> queue, List<IntFloatPair> results) {
        IntFloatPair wp = null;
        
        // reset all values in the queue to MAX, -1
		for (final IntFloatPair p : results) {
			p.second = Float.MAX_VALUE;
			p.first = -1;
			wp = queue.offerItem(p);
		}

        // perform the search
		for (int i = 0; i < this.pnts.length; i++) {
			wp.second = distanceFunc(distance, query, pnts[i]);
			wp.first = i;
			wp = queue.offerItem(wp);
		}
		
        return queue.toOrderedListDestructive();
    }

	@Override
	public int numDimensions() {
		return pnts[0].length;
	}

	@Override
	public int size() {
		return pnts.length;
	}
	
	/**
	 * Get the underlying data points.
	 * 
	 * @return the data points
	 */
	public byte[][] getPoints() {
		return this.pnts;
	}

	/**
	 * Compute the distance between two vectors using the underlying distance
	 * comparison used by this class.
	 * 
	 * @param a
	 *            the first vector
	 * @param b
	 *            the second vector
	 * @return the distance between the two vectors
	 */
	public float computeDistance(byte[] a, byte[] b) {
		if (distance == null)
			return (float) ByteFVComparison.SUM_SQUARE.compare(a, b);
		return (float) distance.compare(a, b);
	}

	/**
	 * Get the distance comparator
	 * 
	 * @return the distance comparator
	 */
	public ByteFVComparator distanceComparator() {
		return this.distance;
	}
}
