/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.objectdetection.haar;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.analysis.algorithm.SummedSqTiltAreaTable;
import org.openimaj.image.objectdetection.haar.Classifier;
import org.openimaj.image.objectdetection.haar.HaarFeatureClassifier;
import org.openimaj.image.objectdetection.haar.StageTreeClassifier;
import org.openimaj.image.objectdetection.haar.ValueClassifier;

@Reference(type=ReferenceType.Inproceedings, author={"Viola, P.", "Jones, M."}, title="Rapid object detection using a boosted cascade of simple features", year="2001", booktitle="Computer Vision and Pattern Recognition, 2001. CVPR 2001. Proceedings of the 2001 IEEE Computer Society Conference on", pages={" I", "511 ", " I", "518 vol.1"}, number="", volume="1", customData={"keywords", " AdaBoost; background regions; boosted simple feature cascade; classifiers; face detection; image processing; image representation; integral image; machine learning; object specific focus-of-attention mechanism; rapid object detection; real-time applications; statistical guarantees; visual object detection; feature extraction; image classification; image representation; learning (artificial intelligence); object detection;", "doi", "10.1109/CVPR.2001.990517", "ISSN", "1063-6919 "})
public class Stage {
    float threshold;
    Classifier[] ensemble;
    Stage successStage;
    Stage failureStage;
    private boolean hasNegativeValueFeatures;

    public Stage(float threshold, Classifier[] trees, Stage successStage, Stage failureStage) {
        this.threshold = threshold;
        this.ensemble = trees;
        this.successStage = successStage;
        this.failureStage = failureStage;
        this.hasNegativeValueFeatures = this.checkForNegativeValueFeatures();
    }

    private boolean checkForNegativeValueFeatures() {
        for (int i = 0; i < this.ensemble.length; ++i) {
            if (!this.checkForNegativeValueFeatures(this.ensemble[i])) continue;
            return true;
        }
        return false;
    }

    private boolean checkForNegativeValueFeatures(Classifier classifier) {
        if (classifier instanceof ValueClassifier) {
            if (((ValueClassifier)classifier).value < 0.0f) {
                return true;
            }
        } else {
            if (this.checkForNegativeValueFeatures(((HaarFeatureClassifier)classifier).left)) {
                return true;
            }
            if (this.checkForNegativeValueFeatures(((HaarFeatureClassifier)classifier).right)) {
                return true;
            }
        }
        return false;
    }

    public boolean pass(SummedSqTiltAreaTable sat, float wvNorm, int x, int y) {
        float total = 0.0f;
        if (this.hasNegativeValueFeatures) {
            for (int i = 0; i < this.ensemble.length; ++i) {
                total += this.ensemble[i].classify(sat, wvNorm, x, y);
            }
            return total >= this.threshold;
        }
        for (int i = 0; i < this.ensemble.length; ++i) {
            if (!((total += this.ensemble[i].classify(sat, wvNorm, x, y)) >= this.threshold)) continue;
            return true;
        }
        return false;
    }

    void updateCaches(StageTreeClassifier cascade) {
        for (int i = 0; i < this.ensemble.length; ++i) {
            this.ensemble[i].updateCaches(cascade);
        }
    }

    public Stage successStage() {
        return this.successStage;
    }

    public Stage failureStage() {
        return this.failureStage;
    }
}

