/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.motion;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.video.Video;
import org.openimaj.video.VideoFrame;
import org.openimaj.video.analyser.VideoAnalyser;
import org.openimaj.video.processing.motion.MotionEstimatorAlgorithm;
import org.openimaj.video.timecode.HrsMinSecFrameTimecode;
import org.openimaj.video.timecode.VideoTimecode;

public abstract class MotionEstimator
extends VideoAnalyser<FImage> {
    private MotionEstimatorAlgorithm estimator = null;
    private Queue<VideoFrame<FImage>> oldFrames = null;
    public Map<Point2d, Point2d> motionVectors = null;

    public MotionEstimator(MotionEstimatorAlgorithm alg) {
        this.estimator = alg;
        this.oldFrames = new LinkedList<VideoFrame<FImage>>();
    }

    public MotionEstimator(Video<FImage> v, MotionEstimatorAlgorithm alg) {
        super(v);
        this.estimator = alg;
        this.oldFrames = new LinkedList<VideoFrame<FImage>>();
    }

    public void analyseFrame(FImage frame) {
        VideoFrame vf = new VideoFrame((Image)frame, (VideoTimecode)new HrsMinSecFrameTimecode(this.getTimeStamp(), this.getFPS()));
        this.motionVectors = this.estimateMotionField(this.estimator, (VideoFrame<FImage>)vf, this.oldFrames.toArray(new VideoFrame[0]));
        this.oldFrames.offer((VideoFrame<FImage>)vf);
        if (this.oldFrames.size() > this.estimator.requiredNumberOfFrames()) {
            this.oldFrames.poll();
        }
    }

    public Map<Point2d, Point2d> getMotionVectors() {
        return this.motionVectors;
    }

    protected abstract Map<Point2d, Point2d> estimateMotionField(MotionEstimatorAlgorithm var1, VideoFrame<FImage> var2, VideoFrame<FImage>[] var3);
}

