/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.shotdetector;

import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.analysis.algorithm.histogram.HistogramAnalyser;
import org.openimaj.math.statistics.distribution.Histogram;
import org.openimaj.video.Video;
import org.openimaj.video.processing.shotdetector.VideoShotDetector;

public class HistogramVideoShotDetector
extends VideoShotDetector<MBFImage> {
    private Histogram lastHistogram;

    public HistogramVideoShotDetector() {
        this.threshold = 5000.0;
    }

    public HistogramVideoShotDetector(double fps) {
        super(fps);
        this.threshold = 5000.0;
    }

    public HistogramVideoShotDetector(Video<MBFImage> video) {
        super(video);
        this.threshold = 5000.0;
    }

    public HistogramVideoShotDetector(Video<MBFImage> video, boolean display) {
        super(video, display);
        this.threshold = 5000.0;
    }

    @Override
    protected double getInterframeDistance(MBFImage frame) {
        HistogramAnalyser hp = new HistogramAnalyser(64);
        if (frame instanceof MBFImage) {
            hp.analyseImage((FImage)frame.getBand(0));
        }
        Histogram newHisto = hp.getHistogram();
        double dist = 0.0;
        if (this.lastHistogram != null) {
            dist = newHisto.compare((DoubleFV)this.lastHistogram, DoubleFVComparison.EUCLIDEAN);
        }
        this.lastHistogram = newHisto;
        return dist;
    }
}

