/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.video.processing.shotdetector;

import java.util.HashMap;
import java.util.Map;
import org.openimaj.image.MBFImage;
import org.openimaj.video.Video;
import org.openimaj.video.processing.shotdetector.VideoShotDetector;

public class CombiShotDetector
extends VideoShotDetector<MBFImage> {
    private Map<VideoShotDetector<MBFImage>, Double> detectors = new HashMap<VideoShotDetector<MBFImage>, Double>();

    public CombiShotDetector() {
        this.threshold = 0.75;
    }

    public CombiShotDetector(Video<MBFImage> video) {
        super(video);
        this.threshold = 0.75;
    }

    public void addVideoShotDetector(VideoShotDetector<MBFImage> detector, double weight) {
        if (weight > 1.0 || weight < 0.0) {
            throw new IllegalArgumentException("Detector weight must be between 0 and 1 inclusive");
        }
        this.detectors.put(detector, weight);
    }

    @Override
    protected double getInterframeDistance(MBFImage thisFrame) {
        double score = 0.0;
        for (VideoShotDetector<MBFImage> detector : this.detectors.keySet()) {
            detector.processFrame(thisFrame);
            if (!detector.wasLastFrameBoundary()) continue;
            score += this.detectors.get(detector).doubleValue();
        }
        return score / (double)this.detectors.size();
    }
}

