/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openjax.json.JsonUtil;

public final class JSON {
    private static String makeIndent(int indent) {
        if (indent == 0) {
            return null;
        }
        if (indent < 0) {
            throw new IllegalArgumentException("indent (" + indent + ") must be non-negative");
        }
        char[] chars = new char[indent + 1];
        Arrays.fill(chars, 1, chars.length, ' ');
        chars[0] = 10;
        return new String(chars);
    }

    private static String encode(Object obj, String spaces) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return JsonUtil.escape((String)obj).insert(0, '\"').append('\"').toString();
        }
        if (obj instanceof Boolean || obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof List) {
            String list = JSON.toString((List)obj, spaces);
            return spaces == null ? list : list.replace("\n", spaces);
        }
        if (obj instanceof Map) {
            String map = JSON.toString((Map)obj, spaces);
            return spaces == null ? map : map.replace("\n", spaces);
        }
        throw new IllegalArgumentException("Illegal object of class: " + obj.getClass().getName());
    }

    public static String toString(Map<String, ?> object) {
        return JSON.toString(object, 0);
    }

    public static String toString(Map<String, ?> object, int indent) {
        return JSON.toString(object, JSON.makeIndent(indent));
    }

    private static String toString(Map<String, ?> object, String spaces) {
        StringBuilder builder = new StringBuilder("{");
        if (object != null) {
            for (Map.Entry<String, ?> entry : object.entrySet()) {
                if (spaces != null) {
                    builder.append(spaces);
                }
                builder.append("\"").append((CharSequence)JsonUtil.escape(entry.getKey())).append("\":");
                if (spaces != null) {
                    builder.append(' ');
                }
                builder.append(JSON.encode(entry.getValue(), spaces)).append(',');
            }
        }
        if (builder.length() > 1) {
            if (spaces == null) {
                builder.setLength(builder.length() - 1);
            } else {
                builder.setCharAt(builder.length() - 1, '\n');
            }
        }
        return builder.append('}').toString();
    }

    public static String toString(List<?> array) {
        return JSON.toString(array, 0);
    }

    public static String toString(List<?> array, int indent) {
        return JSON.toString(array, JSON.makeIndent(indent));
    }

    private static String toString(List<?> array, String spaces) {
        if (array == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder("[");
        boolean backUp = false;
        for (int i = 0; i < array.size(); ++i) {
            Object member = array.get(i);
            String str = JSON.encode(member, spaces);
            if (member instanceof Map || member instanceof List) {
                if (i > 0 && spaces != null) {
                    builder.append(' ');
                } else {
                    backUp = true;
                }
            } else if (spaces != null) {
                builder.append(spaces);
            }
            builder.append(backUp && spaces != null ? str.replaceAll(spaces, "\n") : str).append(',');
        }
        if (builder.length() > 1) {
            if (backUp) {
                builder.setLength(builder.length() - 1);
            } else {
                builder.setCharAt(builder.length() - 1, '\n');
            }
        }
        return builder.append(']').toString();
    }

    private JSON() {
    }
}

