/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

import java.io.IOException;
import java.util.Objects;
import org.openjax.json.JsonHandler;
import org.openjax.json.JsonParseException;
import org.openjax.json.JsonReader;
import org.openjax.json.JsonUtil;

public class JsonParser {
    private final JsonReader reader;

    public JsonParser(JsonReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    public boolean parse(JsonHandler handler) throws IOException, JsonParseException {
        int start;
        if (this.reader.getPosition() == 0) {
            handler.startDocument();
        }
        while ((start = this.reader.readTokenStart()) != -1) {
            int end = this.reader.getPosition();
            char ch = this.reader.buf()[start];
            boolean proceed = end - start == 1 && JsonUtil.isStructural(ch) ? handler.structural(ch) : (JsonUtil.isWhitespace(ch) ? handler.whitespace(this.reader.buf(), start, end) : handler.characters(this.reader.buf(), start, end));
            if (!proceed) continue;
            return false;
        }
        handler.endDocument();
        return true;
    }
}

