/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.libj.util.Buffers;
import org.libj.util.Characters;
import org.libj.util.Numbers;
import org.libj.util.primitive.ArrayIntList;
import org.libj.util.primitive.ArrayLongList;
import org.openjax.json.JsonParseException;
import org.openjax.json.JsonReplayReader;
import org.openjax.json.JsonUtil;

public class JsonReader
extends JsonReplayReader
implements Iterable<String>,
Iterator<String> {
    private static final char[][] literals = new char[][]{{'n', 'u', 'l', 'l'}, {'t', 'r', 'u', 'e'}, {'f', 'a', 'l', 's', 'e'}};
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final int DEFAULT_TOKENS_SIZE = 128;
    private static final int DEFAULT_SCOPE_SIZE = 2;
    private static final double DEFAULT_SCOPE_RESIZE_FACTOR = 2.0;
    private final ArrayLongList positions = new ArrayLongList(128);
    private final ArrayList<long[]> scopes = new ArrayList(2);
    private final ArrayIntList depths = new ArrayIntList(2);
    private int index;
    private int markedIndex = this.index = -1;
    private long[] scope = new long[2];
    private int depth = -1;
    private int nextStart = 0;
    private final boolean ignoreWhitespace;

    public JsonReader(Reader reader) {
        this(reader, true);
    }

    public JsonReader(Reader reader, boolean ignoreWhitespace) {
        super(reader, 2048);
        this.ignoreWhitespace = ignoreWhitespace;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (this.index == index) {
            return;
        }
        if (index < -1 || this.size() <= index) {
            throw new IllegalArgumentException("Index out of range [-1," + (this.size() - 1) + "]: " + index);
        }
        this.setIndex0(index);
    }

    private int setIndex0(int index) {
        int start;
        this.index = index;
        if (index > -1) {
            long position = this.positions.get(index);
            start = Numbers.Compound.decodeInt((long)position, (int)0);
            int end = Numbers.Compound.decodeInt((long)position, (int)1);
            this.setPosition(end);
            this.depth = this.depths.get(index);
        } else {
            long position = this.positions.get(++index);
            start = Numbers.Compound.decodeInt((long)position, (int)0);
            this.setPosition(start);
            this.depth = 0;
        }
        this.scope = this.scopes.get(index);
        return start;
    }

    public int size() {
        return this.positions.size();
    }

    protected int getStartPosition(int index) {
        return Numbers.Compound.decodeInt((long)this.positions.get(index), (int)0);
    }

    protected int getEndPosition(int index) {
        return Numbers.Compound.decodeInt((long)this.positions.get(index), (int)1);
    }

    protected void setPosition(int p) {
        this.buffer.reset(p);
    }

    public int getPosition() {
        return this.buffer.size();
    }

    public String readToken() throws IOException, JsonParseException {
        int end;
        int start;
        if (this.index == -1 || this.getPosition() == this.getEndPosition(this.index)) {
            start = this.nextToken();
            end = this.getEndPosition(this.index);
        } else {
            start = this.getPosition();
            end = this.getEndPosition(this.index);
            this.setPosition(end);
        }
        if (start == -1) {
            return null;
        }
        if (start == end) {
            throw new IllegalStateException("Illegal JSON content [errorOffset: " + start + "]");
        }
        return end - start == 1 ? Characters.toString((char)this.buf()[start]) : new String(this.buf(), start, end - start);
    }

    private boolean hasRemaining() throws IOException, JsonParseException {
        if (this.index != -1 && this.getPosition() < this.getEndPosition(this.index)) {
            return true;
        }
        int start = this.nextToken();
        if (start == -1) {
            return false;
        }
        this.setPosition(start);
        return true;
    }

    public void mark(int readlimit) {
        this.markedIndex = this.getIndex();
        super.mark(readlimit);
    }

    public void reset() {
        this.setIndex(this.markedIndex);
        super.reset();
    }

    @Override
    public int read() throws IOException {
        return this.hasRemaining() ? super.read() : -1;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        while (len != 0 && this.hasRemaining()) {
            int remaining = this.getEndPosition(this.index) - this.getPosition();
            if (remaining > len) {
                return count + super.read(cbuf, off, len);
            }
            if (remaining <= 0) continue;
            remaining = super.read(cbuf, off, remaining);
            len -= remaining;
            off += remaining;
            count += remaining;
        }
        return count;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return super.read(cbuf);
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() throws UncheckedIOException, JsonParseException {
        if (this.index < this.size()) {
            return true;
        }
        try {
            this.nextToken();
            return this.index < this.size();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String next() throws UncheckedIOException, JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return this.readToken();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private int nearestNonWsToken(int offset) {
        block4: {
            if (this.index < offset) {
                return -1;
            }
            char[] buf = this.buf();
            if (this.ignoreWhitespace) {
                return buf[this.getStartPosition(this.index - offset)];
            }
            char ch = buf[this.getStartPosition(this.index)];
            if (JsonUtil.isWhitespace(ch)) {
                // empty if block
            }
            do {
                int n = ++offset;
                ++offset;
                if (n >= this.index) break block4;
            } while (JsonUtil.isWhitespace(ch = buf[this.getStartPosition(this.index + 1 - offset)]));
            return ch;
        }
        return -1;
    }

    private int nextToken() throws IOException, JsonParseException {
        int start = -1;
        if (this.index == -1) {
            start = this.readTokenStart();
            this.index = -1;
        } else if (this.getStartPosition(this.index + 1) == -1) {
            return start;
        }
        this.setIndex0(this.index + 1);
        if (this.index < this.size() - 1) {
            return this.getStartPosition(this.index);
        }
        int beforeIndex = this.index;
        try {
            this.readTokenStart();
        }
        finally {
            if (beforeIndex < this.index) {
                this.setIndex0(this.index - 1);
            }
        }
        return start != -1 ? start : this.getStartPosition(this.index);
    }

    protected int readTokenStart() throws IOException, JsonParseException {
        if (0 < this.size() && this.index > -1 && this.getPosition() != this.getEndPosition(this.index)) {
            throw new IllegalStateException("Buffer position (" + this.getPosition() + ") misaligned with end position (" + this.getEndPosition(this.index) + ") on index (" + this.index + ")");
        }
        if (this.index < this.size() - 1) {
            return this.setIndex0(this.index + 1);
        }
        this.nextStart = 0;
        int ch = this.readNonWS(super.read());
        do {
            int start;
            int ch2;
            if (this.nextStart != 0 || ch == -1) {
                return this.advance(ch, this.nextStart);
            }
            int ch1 = this.nearestNonWsToken(0);
            int n = ch2 = ch1 == -1 ? -1 : this.nearestNonWsToken(1);
            if (ch2 == 58 || ch1 != 34 || !Buffers.get((long[])this.scope, (int)this.depth)) {
                if (ch == 123 || ch == 91) {
                    if (ch1 == 123) {
                        throw new JsonParseException("Expected character '}', but encountered '" + (char)ch + "'", this.getPosition() - 1);
                    }
                    if (ch == 123) {
                        Buffers.set((long[])this.scope, (int)(++this.depth), (double)2.0);
                    } else {
                        Buffers.clear((long[])this.scope, (int)(++this.depth));
                    }
                    this.nextStart = this.getPosition();
                    continue;
                }
                if (ch == 125 || ch == 93) {
                    int expected;
                    if (Buffers.get((long[])this.scope, (int)this.depth--)) {
                        Buffers.clear((long[])this.scope, (int)(this.depth + 1));
                        expected = 125;
                    } else {
                        expected = 93;
                    }
                    if (expected != ch) {
                        throw new JsonParseException("Expected character '" + (char)expected + "', but encountered '" + (char)ch + "'", this.getPosition() - 1);
                    }
                    this.nextStart = this.getPosition();
                    continue;
                }
                if (ch == 44) {
                    this.nextStart = this.getPosition();
                    continue;
                }
                if (this.depth == -1) {
                    throw new JsonParseException("Expected character '{' or '[', but encountered '" + (char)ch + "'", this.getPosition() - 1);
                }
                if (Buffers.get((long[])this.scope, (int)this.depth) && ch1 != 58) {
                    if (ch != 34) {
                        throw new JsonParseException("Expected character '\"', but encountered '" + (char)ch + "'", this.getPosition() - 1);
                    }
                    start = this.getPosition();
                    ch = this.readQuoted();
                    return this.advance(ch, start);
                }
            } else if (ch != 58) {
                throw new JsonParseException("Expected character ':', but encountered '" + (char)ch + "'", this.getPosition() - 1);
            }
            if (!Buffers.get((long[])this.scope, (int)this.depth) || ch1 == 58) {
                start = this.getPosition();
                ch = ch == 34 ? this.readQuoted() : this.readUnquoted(ch);
                return this.advance(ch, start);
            }
            this.nextStart = this.getPosition();
        } while ((ch = super.read()) != -1);
        if (this.depth >= 0) {
            throw new JsonParseException("Missing closing scope character: '" + (Buffers.get((long[])this.scope, (int)this.depth) ? (char)'}' : ']') + "'", this.getPosition());
        }
        return this.advance(ch, this.nextStart);
    }

    protected char[] buf() {
        return this.buffer.buf();
    }

    private int advance(int ch, int pos) {
        if (ch != -1) {
            this.setPosition(this.getPosition() - 1);
        }
        if (++this.index != this.size()) {
            throw new IllegalStateException("Index (" + this.index + ") misaligned with tokens count (" + this.size() + ")");
        }
        this.scopes.add((long[])this.scope.clone());
        this.depths.add(this.depth);
        this.positions.add(Numbers.Compound.encode((int)(--pos), (int)this.getPosition()));
        return pos;
    }

    private int readNonWS(int ch) throws IOException, JsonParseException {
        if (!JsonUtil.isWhitespace(ch)) {
            return ch;
        }
        int start = this.getPosition();
        while (JsonUtil.isWhitespace(ch) && (ch = super.read()) != -1) {
        }
        if (this.index == -1) {
            return ch;
        }
        if (!this.ignoreWhitespace && this.depth != -1 && start != this.getPosition()) {
            this.nextStart = start;
        }
        if (this.depth == -1 && ch != -1) {
            throw new JsonParseException("No content is expected at this point: " + (char)ch, this.getPosition() - 1);
        }
        return ch;
    }

    private int readQuoted() throws IOException {
        int ch;
        int start = this.getPosition();
        boolean escaped = false;
        while ((ch = super.read()) != -1) {
            if (escaped) {
                escaped = false;
                continue;
            }
            if (ch == 92) {
                escaped = true;
                continue;
            }
            if (ch != 34) continue;
            return super.read();
        }
        throw new JsonParseException("Unterminated string", start - 1);
    }

    private int readUnquoted(int ch) throws IOException, JsonParseException {
        if (ch == 45 || 48 <= ch && ch <= 57) {
            int first;
            int prev = first = ch;
            boolean hasDot = false;
            int i = 0;
            while ((ch = super.read()) != -1) {
                if (ch == 46) {
                    if (first == 45 && i == 0) {
                        throw new JsonParseException("Integer component required before fraction part", this.getPosition() - 1);
                    }
                    if (hasDot) {
                        throw new JsonParseException("Illegal character: '" + (char)ch + "'", this.getPosition() - 1);
                    }
                    hasDot = true;
                } else {
                    if (ch < 48 || 57 < ch) break;
                    if (prev == 48 && i == (first == 45 ? 1 : 0)) {
                        throw new JsonParseException("Leading zeros are not allowed", this.getPosition() - 2);
                    }
                }
                ++i;
                prev = ch;
            }
            if (prev == 46) {
                throw new JsonParseException("Decimal point must be followed by one or more digits", this.getPosition() - 1);
            }
            if (ch == 101 || ch == 69) {
                prev = ch;
                i = 0;
                while ((ch = super.read()) != -1) {
                    if (ch == 45 || ch == 43) {
                        first = 126;
                        if (i > 0) {
                            throw new JsonParseException("Illegal character: '" + (char)ch + "'", this.getPosition() - 1);
                        }
                    } else {
                        if (ch < 48 || 57 < ch) break;
                        if (prev == 48 && i == (first == 126 ? 2 : 1)) {
                            throw new JsonParseException("Leading zeros are not allowed", this.getPosition() - 2);
                        }
                    }
                    ++i;
                    prev = ch;
                }
                if (prev == 101 || prev == 69) {
                    throw new JsonParseException("\"" + prev + "\" must be followed by one or more digits", this.getPosition() - 1);
                }
                if (prev == 45 || prev == 43) {
                    throw new JsonParseException("Expected digit, but encountered '" + (char)ch + "'", this.getPosition() - 1);
                }
            }
            if (ch != 93 && ch != 125 && ch != 44 && !JsonUtil.isWhitespace(ch)) {
                throw new JsonParseException(ch == -1 ? "Unexpected end of document" : "Illegal character: '" + (char)ch + "'", this.getPosition() - 1);
            }
            return ch;
        }
        for (int i = 0; i < literals.length; ++i) {
            if (ch != literals[i][0]) continue;
            char[] literal = literals[i];
            for (int j = 1; j < literal.length; ++j) {
                ch = super.read();
                if (ch == literal[j]) continue;
                throw new JsonParseException(ch == -1 ? "Unexpected end of document" : "Illegal character: '" + (char)ch + "'", this.getPosition() - 1);
            }
            ch = super.read();
            if (!JsonUtil.isStructural(ch) && !JsonUtil.isWhitespace(ch)) break;
            return ch;
        }
        throw new JsonParseException(ch == -1 ? "Unexpected end of document" : "Illegal character: '" + (char)ch + "'", this.getPosition() - 1);
    }
}

