/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

import java.io.IOException;
import java.io.Reader;
import org.libj.io.ReplayReader;
import org.libj.util.Numbers;
import org.openjax.json.JsonParseException;

class JsonReplayReader
extends ReplayReader {
    private int pos = -1;
    private char readAhead = '\u0000';

    JsonReplayReader(Reader in, int initialSize) {
        super(in, initialSize);
    }

    JsonReplayReader(Reader in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.buffer.available() > 0) {
            return this.buffer.read();
        }
        if (this.closed) {
            return -1;
        }
        if (this.readAhead != '\u0000') {
            this.buffer.write((int)this.readAhead);
            char tmp = this.readAhead;
            this.readAhead = '\u0000';
            return tmp;
        }
        int ch = this.in.read();
        if (ch == -1) {
            return -1;
        }
        ++this.pos;
        if (ch == 92) {
            ch = this.in.read();
            if (ch == -1) {
                return -1;
            }
            ++this.pos;
            if (ch == 34 || ch == 92) {
                this.readAhead = (char)ch;
                ch = 92;
            } else if (ch == 110) {
                ch = 10;
            } else if (ch == 114) {
                ch = 13;
            } else if (ch == 116) {
                ch = 9;
            } else if (ch == 98) {
                ch = 8;
            } else if (ch == 102) {
                ch = 12;
            } else if (ch == 117) {
                char[] unicode = new char[4];
                for (int i = 0; i < unicode.length; ++i) {
                    int c = this.in.read();
                    if (c == -1) {
                        throw new JsonParseException("Unterminated escape sequence", this.pos);
                    }
                    unicode[i] = (char)c;
                }
                Integer code = Numbers.parseInteger((char[])unicode, (int)16);
                if (code == null) {
                    throw new NumberFormatException(String.valueOf(unicode));
                }
                ch = (char)code.intValue();
            }
        }
        this.buffer.write(ch);
        return ch;
    }

    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int ch;
        int i;
        for (i = 0; i < len && (ch = this.read()) != -1; ++i) {
            cbuf[off + i] = (char)ch;
        }
        return i;
    }
}

