/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.json;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.libj.lang.Classes;
import org.openjax.json.JsonParseException;

public final class JsonUtil {
    public static boolean isStructural(int ch) {
        return ch == 123 || ch == 125 || ch == 91 || ch == 93 || ch == 58 || ch == 44;
    }

    public static boolean isWhitespace(int ch) {
        return ch == 32 || ch == 10 || ch == 13 || ch == 9;
    }

    public static <T extends Number> T parseNumber(Class<T> type, String str) throws JsonParseException {
        int first;
        if (str.length() == 0) {
            throw new IllegalArgumentException("Empty string");
        }
        int i = 0;
        int ch = str.charAt(i);
        if (ch != 45 && (ch < 48 || 57 < ch)) {
            throw new JsonParseException("Illegal first character: '" + (char)ch + "'", i);
        }
        int last = first = ch;
        int len = str.length();
        boolean hasDot = false;
        while (++i < len) {
            ch = str.charAt(i);
            if (ch == 46) {
                if (first == 45 && i == 1) {
                    throw new JsonParseException("Integer component required before fraction part", i);
                }
                if (hasDot) {
                    throw new JsonParseException("Illegal character: '" + (char)ch + "'", i);
                }
                hasDot = true;
            } else {
                if (ch < 48 || 57 < ch) break;
                if (last == 48 && i == (first == 45 ? 2 : 1)) {
                    throw new JsonParseException("Leading zeros are not allowed", i - 1);
                }
            }
            last = ch;
        }
        if (last == 46) {
            throw new JsonParseException("Decimal point must be followed by one or more digits", i);
        }
        int expStart = -1;
        if (i < len) {
            if (ch != 101 && ch != 69) {
                throw new JsonParseException("Illegal character: '" + (char)ch + "'", i);
            }
            last = ch;
            expStart = i + 1;
            while (++i < len) {
                ch = str.charAt(i);
                if (ch == 45 || ch == 43) {
                    first = 126;
                    if (i > expStart) {
                        throw new JsonParseException("Illegal character: '" + (char)ch + "'", i);
                    }
                } else {
                    if (ch < 48 || 57 < ch) break;
                    if (last == 48 && i == expStart + (first == 126 ? 2 : 1)) {
                        throw new JsonParseException("Leading zeros are not allowed", i - 1);
                    }
                }
                last = ch;
            }
            if (last == 101 || last == 69) {
                throw new JsonParseException("\"" + last + "\" must be followed by one or more digits", i);
            }
        }
        if (ch < 48 || 57 < ch) {
            throw new JsonParseException("Expected digit, but encountered '" + (char)ch + "'", i);
        }
        if (type == null) {
            return null;
        }
        if (expStart > -1 && !BigDecimal.class.isAssignableFrom(type)) {
            if (type == BigInteger.class) {
                return (T)new BigDecimal(str).toBigInteger();
            }
            str = new BigDecimal(str).toPlainString();
        }
        if (type == BigDecimal.class) {
            return (T)new BigDecimal(str);
        }
        if (type == BigInteger.class) {
            return (T)new BigInteger(str);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(str);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(str);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(str);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(str);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(str);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(str);
        }
        try {
            return (T)((Number)Classes.newInstance(type, (Object[])new Object[]{str}));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unsupported type: " + type.getName(), e);
        }
    }

    public static StringBuilder escape(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        int len = str.length();
        block8: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '\\': {
                    builder.append('\\').append(ch);
                    continue block8;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block8;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block8;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block8;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block8;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block8;
                }
                default: {
                    if (ch <= '\u001f') {
                        builder.append(String.format("\\u%04x", ch));
                        continue block8;
                    }
                    builder.append(ch);
                }
            }
        }
        return builder;
    }

    public static String unescapeForString(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int ch = str.charAt(i);
            if (ch == 92) {
                if ((ch = str.charAt(++i)) == 34 || ch == 92) {
                    builder.append('\\');
                } else if (ch == 110) {
                    ch = 10;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 116) {
                    ch = 9;
                } else if (ch == 98) {
                    ch = 8;
                } else if (ch == 102) {
                    ch = 12;
                } else if (ch == 117) {
                    ++i;
                    char[] unicode = new char[4];
                    for (int j = 0; j < unicode.length; ++j) {
                        unicode[j] = str.charAt(i + j);
                    }
                    i += unicode.length - 1;
                    ch = (char)Integer.parseInt(new String(unicode), 16);
                }
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    public static String unescape(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            int ch = str.charAt(i);
            if (ch == 92) {
                if ((ch = str.charAt(++i)) == 110) {
                    ch = 10;
                } else if (ch == 114) {
                    ch = 13;
                } else if (ch == 116) {
                    ch = 9;
                } else if (ch == 98) {
                    ch = 8;
                } else if (ch == 102) {
                    ch = 12;
                } else if (ch == 117) {
                    ++i;
                    char[] unicode = new char[4];
                    for (int j = 0; j < unicode.length; ++j) {
                        unicode[j] = str.charAt(i + j);
                    }
                    i += unicode.length - 1;
                    ch = (char)Integer.parseInt(new String(unicode), 16);
                }
            }
            builder.append((char)ch);
        }
        return builder.toString();
    }

    private JsonUtil() {
    }
}

