/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.api;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openjax.xml.api.CharacterDatas;

public class XmlElement
implements Cloneable,
Serializable {
    private static final Pattern qName = Pattern.compile("^[a-zA-Z_][\\w.-]*(:[a-zA-Z_][\\w.-]*)?$");
    private final String name;
    private Map attributes;
    private Collection elements;

    private static String requireQName(Object name) {
        String string = name.toString();
        if (string.length() == 0 || !qName.matcher(string).matches()) {
            throw new IllegalArgumentException(string + " is not a valid xs:QName");
        }
        return string;
    }

    public XmlElement(String name, Map attributes, Collection elements) {
        this.name = XmlElement.requireQName(name);
        this.attributes = attributes;
        this.elements = elements;
    }

    public XmlElement(String name, Map attributes) {
        this(name, attributes, null);
    }

    public XmlElement(String name, Collection elements) {
        this(name, null, elements);
    }

    public XmlElement(String name) {
        this(name, null, null);
    }

    public String getName() {
        return this.name;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setElements(Collection elements) {
        this.elements = elements;
    }

    public Collection getElements() {
        return this.elements;
    }

    private Map cloneAttributes() {
        if (this.attributes instanceof Cloneable) {
            try {
                return (Map)this.attributes.getClass().getMethod("clone", new Class[0]).invoke((Object)this.attributes, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Constructor<?> constructor = this.attributes.getClass().getConstructor(new Class[0]);
            Map clone = (Map)constructor.newInstance(new Object[0]);
            clone.putAll(this.attributes);
            return clone;
        }
        catch (Exception exception) {
            return new HashMap(this.attributes);
        }
    }

    private Collection cloneElements() {
        if (this.elements instanceof Cloneable) {
            try {
                return (Collection)this.elements.getClass().getMethod("clone", new Class[0]).invoke((Object)this.elements, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Constructor<?> constructor = this.elements.getClass().getConstructor(new Class[0]);
            Collection clone = (Collection)constructor.newInstance(new Object[0]);
            clone.addAll(this.elements);
            return clone;
        }
        catch (Exception exception) {
            return new ArrayList(this.elements);
        }
    }

    public XmlElement clone() {
        try {
            XmlElement clone = (XmlElement)super.clone();
            if (this.attributes != null) {
                clone.attributes = this.cloneAttributes();
            }
            if (this.elements != null) {
                clone.elements = this.cloneElements();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XmlElement)) {
            return false;
        }
        XmlElement that = (XmlElement)obj;
        return this.name.equals(that.name) && Objects.equals(this.attributes, that.attributes) && (this.elements == null ? that.elements == null : that.elements != null && this.elements.equals(that.elements));
    }

    public int hashCode() {
        int hashCode = 31 + this.name.hashCode();
        if (this.attributes != null) {
            hashCode = 31 * hashCode + this.attributes.hashCode();
        }
        if (this.elements != null) {
            hashCode = 31 * hashCode + this.elements.hashCode();
        }
        return hashCode;
    }

    public String toString(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("indent (" + indent + ") must be non-negative");
        }
        StringBuilder b = new StringBuilder("<");
        b.append(this.name);
        if (this.attributes != null && this.attributes.size() > 0) {
            StringBuilder value = new StringBuilder();
            for (Map.Entry entry : this.attributes.entrySet()) {
                String name = XmlElement.requireQName(entry.getKey());
                value.append(Objects.requireNonNull(entry.getValue(), "name is null"));
                b.append(' ').append(name).append("=\"");
                CharacterDatas.escapeForAttr(b, value, '\"');
                value.setLength(0);
                b.append('\"');
            }
        }
        if (this.elements == null || this.elements.size() == 0) {
            return b.append("/>").toString();
        }
        b.append('>');
        if (indent == 0) {
            for (Object element : this.elements) {
                b.append(element.toString());
            }
        } else {
            char[] chars = new char[indent + 1];
            Arrays.fill(chars, 1, chars.length, ' ');
            chars[0] = 10;
            String delim = new String(chars);
            for (Object element : this.elements) {
                String string = element instanceof XmlElement ? ((XmlElement)element).toString(indent) : element.toString();
                b.append(chars).append(string.replace("\n", delim));
            }
            b.append('\n');
        }
        return b.append("</").append(this.name).append('>').toString();
    }

    public String toString() {
        return this.toString(0);
    }
}

